/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerTypeDomain;
import com.yunxi.dg.base.center.customer.dto.enums.CustomerTypeSourceTypeEnum;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerBusinessRuntimeException;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerExceptionCode;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerTypePageReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerTypeReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerNameSimpleRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerTypeRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerTypeEo;
import com.yunxi.dg.base.center.customer.eo.DgRCustomerTypeBrandEo;
import com.yunxi.dg.base.center.customer.eo.DgRCustomerTypeDirEo;
import com.yunxi.dg.base.center.customer.service.IDgCustomerService;
import com.yunxi.dg.base.center.customer.service.IDgCustomerTypeService;
import com.yunxi.dg.base.center.customer.service.IDgRCustomerTypeBrandService;
import com.yunxi.dg.base.center.customer.service.IDgRCustomerTypeDirService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="dgCustomerTypeService")
public class DgCustomerTypeServiceImpl
implements IDgCustomerTypeService {
    private static final Logger logger = LoggerFactory.getLogger(DgCustomerTypeServiceImpl.class);
    @Resource
    private IDgCustomerTypeDomain iDgCustomerTypeDomain;
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;
    @Resource(name="dgCustomerService")
    private IDgCustomerService customerService;
    @Resource(name="dgRCustomerTypeBrandService")
    private IDgRCustomerTypeBrandService iDgRCustomerTypeBrandService;
    @Resource(name="dgRCustomerTypeDirService")
    private IDgRCustomerTypeDirService iDgRCustomerTypeDirService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IContext context;

    @Override
    public List<DgCustomerTypeEo> queryAllCustomerType(Integer type) {
        return this.iDgCustomerTypeDomain.queryAllCustomerType(type);
    }

    @Override
    @Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
    public Long saveCustomerType(DgCustomerTypeReqDto customerTypeSaveReqDto) {
        Integer count;
        DgCustomerTypeEo customerTypeEo = new DgCustomerTypeEo();
        customerTypeEo.setCode(customerTypeSaveReqDto.getCode());
        customerTypeEo.setType(customerTypeSaveReqDto.getType());
        customerTypeEo.setId(customerTypeSaveReqDto.getId());
        customerTypeEo.setName(customerTypeSaveReqDto.getName());
        customerTypeEo.setTypeIntroduction(customerTypeSaveReqDto.getTypeIntroduction());
        customerTypeEo.setSort(customerTypeSaveReqDto.getSort());
        DgCustomerTypeEo customerTypeName = new DgCustomerTypeEo();
        customerTypeName.setType(customerTypeSaveReqDto.getType());
        customerTypeName.setName(customerTypeSaveReqDto.getName());
        customerTypeName.setDr(0);
        QueryWrapper queryNameWrapper = new QueryWrapper((Object)customerTypeName);
        if (Objects.nonNull(customerTypeSaveReqDto.getId())) {
            queryNameWrapper.ne((Object)"id", (Object)customerTypeSaveReqDto.getId());
        }
        if (Objects.nonNull(count = this.iDgCustomerTypeDomain.getMapper().selectCount((Wrapper)queryNameWrapper)) && count > 0) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_NAME_EXISTS_CUSTOMER);
        }
        if (null == customerTypeSaveReqDto.getId()) {
            this.iDgCustomerTypeDomain.insert((BaseEo)customerTypeEo);
        } else {
            DgCustomerTypeEo customerTypeEo1 = (DgCustomerTypeEo)this.iDgCustomerTypeDomain.selectByPrimaryKey(customerTypeSaveReqDto.getId());
            if (null == customerTypeEo1) {
                throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.SYS_OBJ_NOT_FOUND, new Object[]{"\u5ba2\u6237\u7c7b\u578b"});
            }
            if (CustomerTypeSourceTypeEnum.fromCode((Integer)customerTypeEo.getCustomerTypeSourceType()) == CustomerTypeSourceTypeEnum.system) {
                customerTypeEo.setSort(customerTypeEo1.getSort());
            }
            this.iDgCustomerTypeDomain.updateSelective((BaseEo)customerTypeEo);
            if (Objects.isNull(customerTypeEo.getSort())) {
                this.iDgCustomerTypeDomain.updateInfoById(customerTypeEo);
            }
        }
        List productBrandIds = customerTypeSaveReqDto.getProductBrandIds();
        List productTypeIds = customerTypeSaveReqDto.getProductTypeIds();
        if (CollUtil.isEmpty((Collection)productBrandIds) && CollUtil.isEmpty((Collection)productTypeIds)) {
            return customerTypeEo.getId();
        }
        Long orgId = this.getCurrentUserOrgIdNoException(this.context.userId());
        if (customerTypeSaveReqDto.getId() != null) {
            this.iDgRCustomerTypeBrandService.deleteByCustomerTypeId(customerTypeSaveReqDto.getId(), orgId);
            this.iDgRCustomerTypeDirService.deleteByCustomerTypeId(customerTypeSaveReqDto.getId(), orgId);
        }
        HashSet brandSet = new HashSet(productBrandIds);
        ArrayList<DgRCustomerTypeBrandEo> rcs = new ArrayList<DgRCustomerTypeBrandEo>(brandSet.size());
        for (Long brandId : brandSet) {
            DgRCustomerTypeBrandEo rCustomerTypeBrandEo = new DgRCustomerTypeBrandEo();
            rCustomerTypeBrandEo.setCustomerTypeId(customerTypeEo.getId());
            rCustomerTypeBrandEo.setBrandId(brandId);
            rCustomerTypeBrandEo.setOrgInfoId(orgId);
            rcs.add(rCustomerTypeBrandEo);
        }
        HashSet dirIdSet = new HashSet(productTypeIds);
        ArrayList<DgRCustomerTypeDirEo> dirEos = new ArrayList<DgRCustomerTypeDirEo>(dirIdSet.size());
        for (Long dirId : dirIdSet) {
            DgRCustomerTypeDirEo rCustomerTypeDirEo = new DgRCustomerTypeDirEo();
            rCustomerTypeDirEo.setCustomerTypeId(customerTypeEo.getId());
            rCustomerTypeDirEo.setDirId(dirId);
            rCustomerTypeDirEo.setOrgInfoId(orgId);
            dirEos.add(rCustomerTypeDirEo);
        }
        this.iDgRCustomerTypeBrandService.insertBatch(rcs);
        this.iDgRCustomerTypeDirService.insertBatch(dirEos);
        return null;
    }

    @Override
    @Transactional
    public void deleteCustomerType(Long customerTypeId) {
        int i = this.customerService.countByCustomerTypeId(customerTypeId);
        if (i > 0) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_TYPE_EXISTS_CUSTOMER_TEMP.getCode(), DgCustomerExceptionCode.CUSTOMER_TYPE_EXISTS_CUSTOMER_TEMP.getMsg());
        }
        DgCustomerTypeEo customerTypeEo = (DgCustomerTypeEo)this.iDgCustomerTypeDomain.selectByPrimaryKey(customerTypeId);
        if (customerTypeEo == null) {
            throw new BizException(DgCustomerExceptionCode.SYSTEM_DATA_NOT_DELETE.getCode(), "\u8be5\u5ba2\u6237\u7c7b\u578b\u5df2\u5220\u9664");
        }
        if (CustomerTypeSourceTypeEnum.fromCode((Integer)customerTypeEo.getCustomerTypeSourceType()) == CustomerTypeSourceTypeEnum.system) {
            throw new BizException("\u7cfb\u7edf\u6570\u636e\u4e0d\u53ef\u5220\u9664");
        }
        this.iDgCustomerTypeDomain.deleteById(customerTypeId);
    }

    @Override
    @Transactional
    public void changeCustomerType(Long originCustomerTypeId, Long finalCustomerTypeId) {
        this.customerService.updateCustomerTypeId(originCustomerTypeId, finalCustomerTypeId);
    }

    @Override
    public DgCustomerTypeEo queryById(Long id) {
        DgCustomerTypeEo customerTypeEo = (DgCustomerTypeEo)this.iDgCustomerTypeDomain.selectByPrimaryKey(id);
        Assert.notNull((Object)customerTypeEo, (String)DgCustomerExceptionCode.CUSTOMER_TYPE_NON_EXIST.getMsg());
        return customerTypeEo;
    }

    @Override
    public DgCustomerTypeRespDto queryByCustomerId(Long customerId) {
        DgCustomerEo customerEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(customerId);
        Assert.notNull((Object)customerEo, (String)DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        DgCustomerTypeEo customerTypeEo = (DgCustomerTypeEo)this.iDgCustomerTypeDomain.selectByPrimaryKey(customerEo.getCustomerTypeId());
        Assert.notNull((Object)customerTypeEo, (String)DgCustomerExceptionCode.CUSTOMER_TYPE_NON_EXIST.getMsg());
        DgCustomerTypeRespDto customerTypeRespDto = new DgCustomerTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)customerTypeEo, (BaseVo)customerTypeRespDto);
        customerTypeRespDto.setProductType("\u6307\u5b9a\u5206\u7c7b");
        customerTypeRespDto.setProductBrand("\u6307\u5b9a\u54c1\u724c");
        if (this.context.userId() != null) {
            Long orgId = this.getCurrentUserOrgIdNoException(this.context.userId());
            List<Long> dirIds = this.iDgRCustomerTypeDirService.findByCustomerTypeId(customerTypeEo.getId(), orgId);
            List<Long> brandIds = this.iDgRCustomerTypeBrandService.findByCustomerTypeId(customerTypeEo.getId(), orgId);
            customerTypeRespDto.setDirIds(dirIds);
            customerTypeRespDto.setProductBrandIds(brandIds);
        }
        return customerTypeRespDto;
    }

    @Override
    public List<DgCustomerNameSimpleRespDto> queryCustomerTyperNameListByIds(List<Long> ids) {
        logger.info("\u83b7\u53d6\u6307\u5b9a\u5ba2\u6237\u7c7b\u578b[{}]", CollectionUtils.isEmpty(ids) ? "\u7a7a\u5bf9\u8c61" : Integer.valueOf(ids.size()));
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DgCustomerNameSimpleRespDto>();
        }
        return this.iDgCustomerTypeDomain.queryCustomeTyperNameListByIds(ids);
    }

    @Override
    public Long getCurrentUserOrgIdNoException(Long userId) {
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(userId, Integer.valueOf(1), Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return null;
        }
        return ((OrganizationDto)pageInfo.getList().get(0)).getId();
    }

    @Override
    public PageInfo<DgCustomerTypeRespDto> queryCustomerTypeByType(DgCustomerTypePageReqDto customerTypePageReqDto) {
        Integer sortType = customerTypePageReqDto.getSortType();
        DgCustomerTypeEo customerTypeEo = new DgCustomerTypeEo();
        customerTypeEo.setType(customerTypePageReqDto.getType());
        if (Objects.nonNull(sortType)) {
            customerTypeEo.addSqlOrderBy((Objects.equals(sortType, 1) ? "-" : "") + "sort", SortOrder.DESC);
        }
        customerTypeEo.addSqlOrderBy("create_time", SortOrder.DESC);
        PageInfo customerTypeEoPageInfo = this.iDgCustomerTypeDomain.selectPage((BaseEo)customerTypeEo, customerTypePageReqDto.getPageNum(), customerTypePageReqDto.getPageSize());
        if (CollUtil.isNotEmpty((Collection)customerTypeEoPageInfo.getList())) {
            ArrayList list = new ArrayList(customerTypeEoPageInfo.getList().size());
            DtoHelper.eoList2DtoList((Collection)customerTypeEoPageInfo.getList(), list, DgCustomerTypeRespDto.class);
            customerTypeEoPageInfo.setList(list);
        }
        return customerTypeEoPageInfo;
    }
}

