/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.domain.IDgCsChannelDomain;
import com.yunxi.dg.base.center.customer.dto.enums.CsGenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.customer.dto.enums.GradeEnum;
import com.yunxi.dg.base.center.customer.dto.request.DgChannelQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCsChannelReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgImportCsChannelReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCsChannelRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCsChannelEo;
import com.yunxi.dg.base.center.customer.service.IDgCsChannelService;
import com.yunxi.dg.base.center.customer.utils.BeanConvertUtil;
import com.yunxi.dg.base.center.customer.utils.GenerateCodeUtils;
import com.yunxi.dg.base.center.customer.utils.MybatisPlusUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgCsChannelServiceImpl
implements IDgCsChannelService {
    private static final String CHANNEL_CODE_PREFIX = "QD";
    @Resource
    private IDgCsChannelDomain iDgCsChannelDomain;

    @Override
    public List<DgCsChannelRespDto> queryTreeChannel(Integer category) {
        return this.buildChannelTreeList(category);
    }

    @Override
    public PageInfo<DgCsChannelRespDto> queryPageChannel(DgChannelQueryReqDto dgChannelQueryReqDto) {
        return BeanConvertUtil.convert(this.iDgCsChannelDomain.selectPage((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)MybatisPlusUtils.lambdaQuery(DgCsChannelEo.class).eq(Objects.nonNull(dgChannelQueryReqDto.getCategory()), DgCsChannelEo::getCategory, (Object)dgChannelQueryReqDto.getCategory())).like(StrUtil.isNotBlank((CharSequence)dgChannelQueryReqDto.getChannelName()), DgCsChannelEo::getChannelName, (Object)dgChannelQueryReqDto.getChannelName())).eq(StrUtil.isNotBlank((CharSequence)dgChannelQueryReqDto.getChannelCode()), DgCsChannelEo::getChannelCode, (Object)dgChannelQueryReqDto.getChannelCode()), dgChannelQueryReqDto.getPageNum(), dgChannelQueryReqDto.getPageSize()), DgCsChannelRespDto.class);
    }

    @Override
    public DgCsChannelRespDto getChannelDetailById(Long id) {
        DgCsChannelRespDto channelById = this.getChannelById(id);
        return channelById;
    }

    @Override
    public DgCsChannelRespDto getChannelParentDetailById(Long id) {
        DgCsChannelRespDto channelById = this.getChannelById(id);
        return this.getChannelParentDetailById(channelById);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addChannelBatch(List<DgCsChannelReqDto> csChannelList) {
        this.verifyInParameterAddChannelBatch(csChannelList);
        return this.executeSaveChannelBatch(csChannelList);
    }

    @Override
    public Long addChannel(DgCsChannelReqDto csChannelReqDto) {
        this.verifyInParameterAddChannel(csChannelReqDto);
        return this.executeSaveChannel(csChannelReqDto);
    }

    @Override
    public void modifyChannel(DgCsChannelReqDto csChannel) {
        this.verifyInParameterModifyChannel(csChannel);
        DgCsChannelEo dgCsChannelEo = (DgCsChannelEo)this.iDgCsChannelDomain.selectByPrimaryKey(csChannel.getId());
        this.handleModifyChannel(dgCsChannelEo, csChannel);
        this.iDgCsChannelDomain.update((BaseEo)dgCsChannelEo);
    }

    @Override
    public Long removeChannel(Long id) {
        this.iDgCsChannelDomain.deleteById(id);
        return 1L;
    }

    @Override
    public List<DgCsChannelRespDto> queryListChannelByCodes(List<String> codes) {
        return BeanUtil.copyToList((Collection)this.iDgCsChannelDomain.getMapper().selectList((Wrapper)MybatisPlusUtils.lambdaQuery(DgCsChannelEo.class).in(DgCsChannelEo::getChannelCode, codes)), DgCsChannelRespDto.class);
    }

    @Override
    public List<DgCsChannelRespDto> queryListChannelByIds(List<Long> ids) {
        return BeanUtil.copyToList((Collection)this.iDgCsChannelDomain.selectByIds(ids), DgCsChannelRespDto.class);
    }

    @Override
    public Long importAddChannelBatch(List<DgImportCsChannelReqDto> importCsChannelReqDtos) {
        Map<String, DgCsChannelEo> channelEoMap = this.queryImportChannelMap(importCsChannelReqDtos);
        this.handleWithImportChannelInfoBatch(channelEoMap, importCsChannelReqDtos);
        return importCsChannelReqDtos.size();
    }

    private void handleWithImportChannelInfoBatch(Map<String, DgCsChannelEo> channelEoMap, List<DgImportCsChannelReqDto> importCsChannelReqDtos) {
        for (DgImportCsChannelReqDto channelReqDto : importCsChannelReqDtos) {
            DgCsChannelEo channelEo = new DgCsChannelEo();
            if (StrUtil.isNotBlank((CharSequence)channelReqDto.getFirstChannelCode())) {
                channelEo = this.executeImportChannelSaveOrUpdate(channelEoMap, channelReqDto, channelReqDto.getFirstChannelCode(), channelReqDto.getFirstChannelName(), GradeEnum.FIRST_GRADE);
            }
            if (StrUtil.isNotBlank((CharSequence)channelReqDto.getSecondChannelCode())) {
                channelReqDto.setParentId(channelEo.getId());
                channelEo = this.executeImportChannelSaveOrUpdate(channelEoMap, channelReqDto, channelReqDto.getSecondChannelCode(), channelReqDto.getSecondChannelName(), GradeEnum.SECOND_GRADE);
            }
            if (!StrUtil.isNotBlank((CharSequence)channelReqDto.getThirdChannelCode())) continue;
            channelReqDto.setParentId(channelEo.getId());
            this.executeImportChannelSaveOrUpdate(channelEoMap, channelReqDto, channelReqDto.getThirdChannelCode(), channelReqDto.getThirdChannelName(), GradeEnum.THIRD_GRADE);
        }
    }

    private DgCsChannelEo executeImportChannelSaveOrUpdate(Map<String, DgCsChannelEo> channelEoMap, DgImportCsChannelReqDto channelReqDto, String channelCode, String channelName, GradeEnum gradeEnum) {
        DgCsChannelEo dgCsChannelEo = channelEoMap.getOrDefault(channelCode, new DgCsChannelEo());
        if (Objects.nonNull(dgCsChannelEo)) {
            channelReqDto.setParentId(dgCsChannelEo.getParentId());
            channelReqDto.setId(dgCsChannelEo.getId());
        } else {
            dgCsChannelEo.setParentId(channelReqDto.getParentId());
        }
        dgCsChannelEo.setChannelName(channelName);
        dgCsChannelEo.setChannelCode(channelCode);
        dgCsChannelEo.setGrade(gradeEnum.getCode());
        dgCsChannelEo.setStatus(channelReqDto.getStatus());
        dgCsChannelEo.setAuth(channelReqDto.getGrade());
        dgCsChannelEo.setDistribution(channelReqDto.getDistribution());
        dgCsChannelEo.setSystemType(channelReqDto.getSystemType());
        this.iDgCsChannelDomain.saveOrUpdate((BaseEo)dgCsChannelEo);
        return dgCsChannelEo;
    }

    private Map<String, DgCsChannelEo> queryImportChannelMap(List<DgImportCsChannelReqDto> importCsChannelReqDtos) {
        List<String> channelCodes = this.extractImportChannelCode(importCsChannelReqDtos);
        List dgCsChannelEos = this.iDgCsChannelDomain.selectList((Wrapper)MybatisPlusUtils.lambdaQuery(DgCsChannelEo.class).in(DgCsChannelEo::getChannelCode, channelCodes));
        return ((List)Optional.ofNullable(dgCsChannelEos).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgCsChannelEo::getChannelCode, Function.identity()));
    }

    private List<String> extractImportChannelCode(List<DgImportCsChannelReqDto> importCsChannelReqDtos) {
        ArrayList<String> codes = new ArrayList<String>();
        for (DgImportCsChannelReqDto channelReqDto : importCsChannelReqDtos) {
            if (StrUtil.isNotBlank((CharSequence)channelReqDto.getFirstChannelCode())) {
                codes.add(channelReqDto.getFirstChannelCode());
            }
            if (StrUtil.isNotBlank((CharSequence)channelReqDto.getSecondChannelCode())) {
                codes.add(channelReqDto.getSecondChannelCode());
            }
            if (!StrUtil.isNotBlank((CharSequence)channelReqDto.getThirdChannelCode())) continue;
            codes.add(channelReqDto.getThirdChannelCode());
        }
        return codes;
    }

    private void handleModifyChannel(DgCsChannelEo oldChannel, DgCsChannelReqDto newChannel) {
        oldChannel.setChannelName(newChannel.getChannelName());
        oldChannel.setRemark(newChannel.getRemark());
        oldChannel.setStatus(newChannel.getStatus());
        oldChannel.setSystemType(newChannel.getSystemType());
    }

    private void verifyInParameterModifyChannel(DgCsChannelReqDto csChannel) {
        AssertUtils.notNull((Object)csChannel, (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)csChannel.getId(), (String)"\u4fee\u6539\u6e20\u9053id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private Long executeSaveChannelBatch(List<DgCsChannelReqDto> csChannelList) {
        csChannelList.stream().forEach(e -> this.executeSaveChannel((DgCsChannelReqDto)e));
        return csChannelList.size();
    }

    private Long executeSaveChannel(DgCsChannelReqDto channelReqDto) {
        DgCsChannelEo channel = Optional.ofNullable(this.getLastChannelByGradeAndParentId(channelReqDto.getGrade(), channelReqDto.getParentId())).orElse((DgCsChannelEo)this.iDgCsChannelDomain.selectByPrimaryKey(channelReqDto.getParentId()));
        if (StringUtils.isEmpty((CharSequence)channelReqDto.getChannelCode())) {
            channelReqDto.setChannelCode(GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.CHANNEL.getCode()).getCode());
        }
        DgCsChannelEo channelEo = (DgCsChannelEo)BeanUtil.toBean((Object)channelReqDto, DgCsChannelEo.class);
        this.iDgCsChannelDomain.insert((BaseEo)channelEo);
        return channelEo.getId();
    }

    private DgCsChannelEo getLastChannelByGradeAndParentId(Integer grade, Long pId) {
        return (DgCsChannelEo)this.iDgCsChannelDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCsChannelEo.class).eq(DgCsChannelEo::getGrade, (Object)grade)).eq(pId != null && pId > 0L, DgCsChannelEo::getParentId, (Object)pId)).orderByDesc(BaseEo::getCreateTime)).last("  LIMIT 1 "));
    }

    private void verifyInParameterAddChannelBatch(List<DgCsChannelReqDto> csChannelList) {
        AssertUtils.notEmpty(csChannelList, (String)"\u6dfb\u52a0\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
        csChannelList.stream().forEach(dgCsChannelReqDto -> this.verifyInParameterAddChannel((DgCsChannelReqDto)dgCsChannelReqDto));
    }

    private void verifyInParameterAddChannel(DgCsChannelReqDto dgCsChannelReqDto) {
        AssertUtils.notBlank((String)dgCsChannelReqDto.getChannelName(), (String)"\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgCsChannelReqDto.getCategory(), (String)"\u6e20\u9053\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgCsChannelReqDto.getStatus(), (String)"\u6e20\u9053\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgCsChannelReqDto.getSystemType(), (String)"\u662f\u5426\u7b2c\u4e09\u65b9\u4e0d\u80fd\u4e3a\u7a7a");
        DgCsChannelEo csChannelEo = new DgCsChannelEo();
        csChannelEo.setCategory(dgCsChannelReqDto.getCategory());
        csChannelEo.setChannelName(dgCsChannelReqDto.getChannelName());
        List csChannelEoList = this.iDgCsChannelDomain.selectList((BaseEo)csChannelEo);
        AssertUtils.isFalse((boolean)CollectionUtils.isNotEmpty((Collection)csChannelEoList), (String)"\u8be5\u6e20\u9053\u5df2\u7ecf\u5b58\u5728");
    }

    private String extractNewChannelCode(String channelCode, Integer grade) {
        if (StrUtil.isBlank((CharSequence)channelCode)) {
            return String.format("%s01", CHANNEL_CODE_PREFIX);
        }
        if (StrUtil.count((CharSequence)channelCode, (CharSequence)"-") < grade - 1) {
            return String.format("%s-%02d", channelCode, 1);
        }
        if (channelCode.indexOf("-") < 0) {
            String suffixCode = channelCode.replace(CHANNEL_CODE_PREFIX, "");
            Integer incrCode = Integer.valueOf(suffixCode) + 1;
            return String.format("%s%02d", CHANNEL_CODE_PREFIX, incrCode);
        }
        String suffixCode = channelCode.substring(channelCode.lastIndexOf("-") + 1);
        Integer incrCode = Integer.valueOf(suffixCode) + 1;
        return String.format("%s-%02d", channelCode.substring(0, channelCode.lastIndexOf("-")), incrCode);
    }

    private DgCsChannelRespDto getChannelParentDetailById(DgCsChannelRespDto dgCsChannelRespDto) {
        if (dgCsChannelRespDto.getParentId() != null && !dgCsChannelRespDto.getParentId().equals(0L)) {
            DgCsChannelRespDto channelParentDto = this.getChannelById(dgCsChannelRespDto.getParentId());
            channelParentDto.setChildren((List)Lists.newArrayList((Object[])new DgCsChannelRespDto[]{dgCsChannelRespDto}));
            return this.getChannelParentDetailById(channelParentDto);
        }
        return dgCsChannelRespDto;
    }

    private DgCsChannelRespDto getChannelById(Long id) {
        DgCsChannelEo channelEo = (DgCsChannelEo)this.iDgCsChannelDomain.selectByPrimaryKey(id);
        return (DgCsChannelRespDto)BeanUtil.toBean((Object)channelEo, DgCsChannelRespDto.class);
    }

    private List<DgCsChannelRespDto> buildChannelTreeList(Integer category) {
        List list = BeanConvertUtil.copyToList((Collection)this.iDgCsChannelDomain.queryListChannel(category), DgCsChannelRespDto.class);
        Map<Long, List<DgCsChannelRespDto>> map = list.stream().collect(Collectors.groupingBy(DgCsChannelRespDto::getParentId));
        if (CollectionUtils.isNotEmpty((Collection)map.get(0L))) {
            List<DgCsChannelRespDto> bizCsChannel = map.get(0L);
            for (DgCsChannelRespDto channelRespDto : bizCsChannel) {
                this.setData(channelRespDto, map);
            }
            return bizCsChannel;
        }
        return null;
    }

    private void setData(DgCsChannelRespDto bizCsChannel, Map<Long, List<DgCsChannelRespDto>> map) {
        List<DgCsChannelRespDto> channelRespDtoList;
        if (CollectionUtils.isNotEmpty((Collection)map.get(bizCsChannel.getId())) && CollectionUtils.isNotEmpty(channelRespDtoList = map.get(bizCsChannel.getId()))) {
            bizCsChannel.setChildren(channelRespDtoList);
            for (DgCsChannelRespDto channelRespDto : channelRespDtoList) {
                this.setData(channelRespDto, map);
            }
        }
    }
}

