/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import cn.hutool.core.lang.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.customer.domain.IDgContactsInfoDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerDomain;
import com.yunxi.dg.base.center.customer.dto.request.DgContactsInfoAddReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgContactsInfoModifyReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgContactsInfoQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgContactsInfoRespDto;
import com.yunxi.dg.base.center.customer.eo.DgContactsInfoEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerEo;
import com.yunxi.dg.base.center.customer.service.IDgContactsInfoService;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgContactsInfoServiceImpl
implements IDgContactsInfoService {
    @Resource
    private IDgContactsInfoDomain iDgContactsInfoDomain;
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addContactsInfo(DgContactsInfoAddReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DgContactsInfoEo contactsInfoEo = new DgContactsInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)contactsInfoEo);
        this.iDgContactsInfoDomain.insert((BaseEo)contactsInfoEo);
        if (null != reqDto.getStatus() && reqDto.getStatus() == 1) {
            this.iDgContactsInfoDomain.updateStatusByOrgInfoId(contactsInfoEo.getOrgInfoId(), contactsInfoEo.getId());
        }
        return contactsInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyContactsInfo(DgContactsInfoModifyReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DgContactsInfoEo contactsInfoEo = new DgContactsInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)contactsInfoEo);
        this.iDgContactsInfoDomain.updateSelective((BaseEo)contactsInfoEo);
        if (null != reqDto.getStatus() && reqDto.getStatus() == 1) {
            this.iDgContactsInfoDomain.updateStatusByOrgInfoId(contactsInfoEo.getOrgInfoId(), contactsInfoEo.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeContactsInfo(Long id) {
        this.iDgContactsInfoDomain.deleteById(id);
    }

    @Override
    public DgContactsInfoRespDto queryContactsInfoById(Long id) {
        DgContactsInfoEo contactsInfoEo = (DgContactsInfoEo)this.iDgContactsInfoDomain.selectByPrimaryKey(id);
        if (contactsInfoEo == null) {
            return null;
        }
        DgContactsInfoRespDto contactsInfoRespDto = new DgContactsInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)contactsInfoEo, (BaseVo)contactsInfoRespDto);
        return contactsInfoRespDto;
    }

    @Override
    public PageInfo<DgContactsInfoRespDto> queryContactsInfoByPage(DgContactsInfoQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        DgContactsInfoEo contactsInfoEo = new DgContactsInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)contactsInfoEo);
        contactsInfoEo.addSqlOrderBy("create_time", SortOrder.DESC);
        PageInfo eoPageInfo = this.iDgContactsInfoDomain.selectPage((BaseEo)contactsInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DgContactsInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<DgContactsInfoRespDto> queryContactsInfoListByOrgInfoId(Long orgInfoId) {
        DgContactsInfoEo contactsInfoEo = new DgContactsInfoEo();
        contactsInfoEo.setOrgInfoId(orgInfoId);
        contactsInfoEo.setDr(CommonConstants.Dr.NO);
        List contactsInfoEoList = this.iDgContactsInfoDomain.selectList((BaseEo)contactsInfoEo);
        ArrayList<DgContactsInfoRespDto> contactsInfoDtoList = new ArrayList<DgContactsInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)contactsInfoEoList, contactsInfoDtoList, DgContactsInfoRespDto.class);
        return contactsInfoDtoList;
    }

    @Override
    public void batchAddContactsInfo(List<DgContactsInfoAddReqDto> contactsInfoAddReqDtoList) {
        if (CollectionUtils.isNotEmpty(contactsInfoAddReqDtoList)) {
            ArrayList<DgContactsInfoEo> contactsInfoEoList = new ArrayList<DgContactsInfoEo>();
            for (DgContactsInfoAddReqDto reqDto : contactsInfoAddReqDtoList) {
                DgContactsInfoEo contactsInfoEo = new DgContactsInfoEo();
                DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)contactsInfoEo);
                contactsInfoEoList.add(contactsInfoEo);
            }
            if (CollectionUtils.isNotEmpty(contactsInfoEoList)) {
                this.iDgContactsInfoDomain.insertBatch(contactsInfoEoList);
            }
        }
    }

    @Override
    public void batchUpdateContactsInfo(List<DgContactsInfoAddReqDto> contactsInfoAddReqDtoList) {
        if (CollectionUtils.isNotEmpty(contactsInfoAddReqDtoList)) {
            for (DgContactsInfoAddReqDto contactsInfoAddReqDto : contactsInfoAddReqDtoList) {
                DgContactsInfoEo queryEo = new DgContactsInfoEo();
                queryEo.setCustomerId(contactsInfoAddReqDto.getCustomerId());
                queryEo.setDr(CommonConstants.Dr.NO);
                List contactsInfoEoList = this.iDgContactsInfoDomain.selectList((BaseEo)queryEo);
                if (!CollectionUtils.isNotEmpty((Collection)contactsInfoEoList)) continue;
                DgContactsInfoEo contactsInfoEo = new DgContactsInfoEo();
                DtoHelper.dto2Eo((BaseVo)contactsInfoAddReqDto, (BaseEo)contactsInfoEo);
                contactsInfoEo.setId(((DgContactsInfoEo)contactsInfoEoList.get(0)).getId());
                this.iDgContactsInfoDomain.updateSelective((BaseEo)contactsInfoEo);
            }
        }
    }

    @Override
    public List<DgContactsInfoRespDto> queryContactsInfoListByCustomerId(Long customerId) {
        if (null == customerId) {
            return null;
        }
        DgContactsInfoEo queryEo = new DgContactsInfoEo();
        queryEo.setCustomerId(customerId);
        queryEo.setDr(CommonConstants.Dr.NO);
        List contactsInfoEoList = this.iDgContactsInfoDomain.selectList((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)contactsInfoEoList)) {
            ArrayList<DgContactsInfoRespDto> contactsInfoDtoList = new ArrayList<DgContactsInfoRespDto>();
            DtoHelper.eoList2DtoList((Collection)contactsInfoEoList, contactsInfoDtoList, DgContactsInfoRespDto.class);
            return contactsInfoDtoList;
        }
        return null;
    }

    @Override
    public List<DgContactsInfoRespDto> queryContactsInfoByCustomerCode(String customerCode) {
        DgCustomerEo customerEo = new DgCustomerEo();
        customerEo.setCode(customerCode);
        DgCustomerEo dgCustomerEo = (DgCustomerEo)this.iDgCustomerDomain.selectOne((BaseEo)customerEo);
        if (null != dgCustomerEo && null != dgCustomerEo.getId()) {
            return this.queryContactsInfoListByCustomerId(dgCustomerEo.getId());
        }
        return null;
    }
}

