/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.apiimpl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.yunxi.dg.base.center.customer.api.IDgCustomerImportLogApi;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerImportLogDomain;
import com.yunxi.dg.base.center.customer.dto.enums.ImportStatusEnum;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerImportSaveReqDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerImportLogEo;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DgCustomerImportLogApiImpl
implements IDgCustomerImportLogApi {
    private static final Logger logger = LoggerFactory.getLogger(DgCustomerImportLogApiImpl.class);
    @Autowired
    private IDgCustomerImportLogDomain iDgCustomerImportLogDomain;

    public RestResponse<Void> save(@Valid DgCustomerImportSaveReqDto customerImportSaveReqDto) {
        if (null == customerImportSaveReqDto.getUrl() || null == customerImportSaveReqDto.getOperator() || null == customerImportSaveReqDto.getImportType()) {
            return new RestResponse("100000", "url\u8def\u5f84\u6216\u5bfc\u5165\u7c7b\u578b\u6216\u64cd\u4f5c\u4eba\u4e3a\u7a7a");
        }
        DgCustomerImportLogEo customerImportLogEo = new DgCustomerImportLogEo();
        customerImportLogEo.setId(customerImportSaveReqDto.getId());
        customerImportLogEo.setImportFileName(customerImportSaveReqDto.getFileName());
        customerImportLogEo.setStatus(ImportStatusEnum.LOADING.getCode());
        customerImportLogEo.setImportType(customerImportSaveReqDto.getImportType());
        customerImportLogEo.setCreatePerson(customerImportSaveReqDto.getOperator());
        DtoHelper.dto2Eo((BaseVo)customerImportSaveReqDto, (BaseEo)customerImportLogEo);
        this.iDgCustomerImportLogDomain.insert((BaseEo)customerImportLogEo);
        return RestResponse.VOID;
    }
}

