/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.convert.entity.ItemBlacklistConverter;
import com.yunxi.dg.base.center.inventory.dao.das.IItemBlacklistDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IItemBlacklistDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IItemBlacklistDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.ItemBlacklistDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ItemBlacklistDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ItemBlacklistPageReqDto;
import com.yunxi.dg.base.center.inventory.eo.ItemBlacklistDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ItemBlacklistEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.codegenerate.DgCodeGenerateUtil;
import com.yunxi.dg.base.center.inventory.service.entity.IItemBlacklistService;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemBlacklistServiceImpl
extends BaseServiceImpl<ItemBlacklistDto, ItemBlacklistEo, IItemBlacklistDomain>
implements IItemBlacklistService {
    @Resource
    private IItemBlacklistDas iItemBlacklistDas;
    @Resource
    private IItemBlacklistDomain iItemBlacklistDomain;
    @Resource
    private IItemBlacklistDetailDomain detailDomain;
    @Autowired
    private DgCodeGenerateUtil codeGenerateUtil;
    @Autowired
    IPhysicsWarehouseDomain physicsWarehouseDomain;

    public ItemBlacklistServiceImpl(IItemBlacklistDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ItemBlacklistDto, ItemBlacklistEo> converter() {
        return ItemBlacklistConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addItemBlacklist(ItemBlacklistDto dto) {
        this.check(dto);
        if (null == dto.getId()) {
            String ruleNo = this.codeGenerateUtil.generateNo("DBH", 6);
            List detailDtos = dto.getDetailDtos();
            ItemBlacklistEo eo = new ItemBlacklistEo();
            BeanUtils.copyProperties((Object)dto, (Object)eo);
            eo.setRuleNo(ruleNo);
            eo.setRuleState(ValidFlagEnum.ENABLE.getCode());
            ArrayList detailEos = Lists.newArrayList();
            detailDtos.forEach(o -> {
                ItemBlacklistDetailEo detailEo = new ItemBlacklistDetailEo();
                BeanUtils.copyProperties((Object)o, (Object)detailEo);
                detailEo.setRuleNo(ruleNo);
                detailEo.setRuleName(dto.getRuleName());
                if (CollectionUtils.isNotEmpty((Collection)o.getBatchList())) {
                    detailEo.setBatch(JSON.toJSONString((Object)o.getBatchList()));
                }
                detailEo.setPhysicsWarehouseCode(dto.getPhysicsWarehouseCode());
                detailEo.setPhysicsWarehouseName(dto.getPhysicsWarehouseName());
                detailEos.add(detailEo);
            });
            this.iItemBlacklistDomain.insert((BaseEo)eo);
            this.detailDomain.insertBatch((List)detailEos);
            return eo.getId();
        }
        ItemBlacklistEo blacklistEo = (ItemBlacklistEo)this.iItemBlacklistDomain.getMapper().findById(dto.getId());
        AssertUtils.notNull((Object)blacklistEo, (String)"\u627e\u4e0d\u5230\u8be5\u89c4\u5219");
        List detailEoList = this.detailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ItemBlacklistDetailEo.class).eq(ItemBlacklistDetailEo::getRuleNo, (Object)blacklistEo.getRuleNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        List<Long> ids = detailEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        ids.forEach(id -> this.detailDomain.deleteById(id));
        List detailDtos = dto.getDetailDtos();
        ItemBlacklistEo eo = new ItemBlacklistEo();
        BeanUtils.copyProperties((Object)dto, (Object)eo);
        eo.setId(blacklistEo.getId());
        eo.setRuleState(blacklistEo.getRuleState());
        eo.setRuleNo(blacklistEo.getRuleNo());
        ArrayList detailEos = Lists.newArrayList();
        detailDtos.forEach(o -> {
            ItemBlacklistDetailEo detailEo = new ItemBlacklistDetailEo();
            BeanUtils.copyProperties((Object)o, (Object)detailEo);
            detailEo.setRuleNo(blacklistEo.getRuleNo());
            detailEo.setRuleName(dto.getRuleName());
            if (CollectionUtils.isNotEmpty((Collection)o.getBatchList())) {
                detailEo.setBatch(JSON.toJSONString((Object)o.getBatchList()));
            }
            detailEo.setPhysicsWarehouseCode(dto.getPhysicsWarehouseCode());
            detailEo.setPhysicsWarehouseName(dto.getPhysicsWarehouseName());
            detailEos.add(detailEo);
        });
        this.iItemBlacklistDomain.update((BaseEo)eo);
        this.detailDomain.insertBatch((List)detailEos);
        return eo.getId();
    }

    private void check(ItemBlacklistDto dto) {
        AssertUtils.notNull((Object)dto.getRuleName(), (String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)dto.getDetailDtos(), (String)"\u89c4\u5219\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getPhysicsWarehouseCode(), (String)"\u7269\u7406\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getRuleLifespan(), (String)"\u89c4\u5219\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getConfigureRules(), (String)"\u914d\u7f6e\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public PageInfo<ItemBlacklistDto> page(ItemBlacklistPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List dtoList = this.iItemBlacklistDas.page(dto);
        return new PageInfo(dtoList);
    }

    @Override
    public List<ItemBlacklistDto> queryPhysicsItemBlack(ItemBlacklistPageReqDto dto) {
        AssertUtils.notNull((Object)dto.getPhysicsWarehouseCode(), (String)"\u7269\u7406\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
        List itemBlacklistDtos = this.iItemBlacklistDas.queryNewPhysicsItemBlack(dto);
        if (CollectionUtils.isEmpty((Collection)itemBlacklistDtos)) {
            return Lists.newArrayList();
        }
        dto.setRuleNo(((ItemBlacklistDto)itemBlacklistDtos.get(0)).getRuleNo());
        List dtoList = this.iItemBlacklistDas.queryPhysicsItemBlack(dto);
        ArrayList<ItemBlacklistDto> detailDtos = new ArrayList<ItemBlacklistDto>();
        dtoList.forEach(o -> {
            if (StringUtils.isNotBlank((CharSequence)o.getBatch())) {
                List batchList = JSON.parseArray((String)o.getBatch(), String.class);
                batchList.forEach(batch -> {
                    ItemBlacklistDto detailDto = new ItemBlacklistDto();
                    detailDto.setRuleNo(o.getRuleNo());
                    detailDto.setPhysicsWarehouseCode(o.getPhysicsWarehouseCode());
                    detailDto.setConfigureRules(o.getConfigureRules());
                    detailDto.setSkuCode(o.getSkuCode());
                    detailDto.setBatch(batch);
                    detailDtos.add(detailDto);
                });
            } else {
                ItemBlacklistDto detailDto = new ItemBlacklistDto();
                detailDto.setRuleNo(o.getRuleNo());
                detailDto.setPhysicsWarehouseCode(o.getPhysicsWarehouseCode());
                detailDto.setConfigureRules(o.getConfigureRules());
                detailDto.setSkuCode(o.getSkuCode());
                detailDtos.add(detailDto);
            }
        });
        return detailDtos;
    }

    @Override
    public List<ItemBlacklistDto> queryPhysicsItemBlackList(ItemBlacklistPageReqDto dto) {
        AssertUtils.notNull((Object)dto.getOwnPhysicalWarehouseId(), (String)"\u7269\u7406\u4ed3id\u4e0d\u80fd\u4e3a\u7a7a");
        PhysicsWarehouseEo warehouseEo = (PhysicsWarehouseEo)this.physicsWarehouseDomain.getMapper().findById(Long.valueOf(dto.getOwnPhysicalWarehouseId()));
        dto.setPhysicsWarehouseCode(warehouseEo.getWarehouseCode());
        List itemBlacklistDtos = this.iItemBlacklistDas.queryNewPhysicsItemBlack(dto);
        if (CollectionUtils.isEmpty((Collection)itemBlacklistDtos)) {
            return Lists.newArrayList();
        }
        dto.setRuleNo(((ItemBlacklistDto)itemBlacklistDtos.get(0)).getRuleNo());
        List dtoList = this.iItemBlacklistDas.queryPhysicsItemBlack(dto);
        return dtoList;
    }

    @Override
    public ItemBlacklistDto queryDetails(ItemBlacklistPageReqDto dto) {
        AssertUtils.notNull((Object)dto.getRuleNo(), (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List itemBlacklistEos = this.iItemBlacklistDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ItemBlacklistEo.class).eq(ItemBlacklistEo::getRuleNo, (Object)dto.getRuleNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)itemBlacklistEos)) {
            return null;
        }
        ItemBlacklistEo itemBlacklistEo = (ItemBlacklistEo)itemBlacklistEos.get(0);
        ItemBlacklistDto itemBlacklistDto = new ItemBlacklistDto();
        BeanUtils.copyProperties((Object)itemBlacklistEo, (Object)itemBlacklistDto);
        List detailEos = this.detailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ItemBlacklistDetailEo.class).eq(ItemBlacklistDetailEo::getRuleNo, (Object)dto.getRuleNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        ArrayList dtoList = Lists.newArrayList();
        detailEos.forEach(o -> {
            ItemBlacklistDetailDto detailDto = new ItemBlacklistDetailDto();
            BeanUtils.copyProperties((Object)o, (Object)detailDto);
            dtoList.add(detailDto);
        });
        itemBlacklistDto.setDetailDtos((List)dtoList);
        return itemBlacklistDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteList(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        for (Long id : ids) {
            ItemBlacklistEo eo = (ItemBlacklistEo)this.iItemBlacklistDomain.getMapper().findById(id);
            AssertUtils.notNull((Object)eo, (String)"\u627e\u4e0d\u5230\u8be5\u89c4\u5219");
            if (Objects.equals(EnableDisableEnum.ENABLE.getCode(), eo.getRuleState())) {
                throw new BizException("\u542f\u7528\u72b6\u6001\u4e0b\u7684\u89c4\u5219\u4e0d\u53ef\u5220\u9664");
            }
            this.iItemBlacklistDomain.deleteById(id);
            List detailEos = this.detailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ItemBlacklistDetailEo.class).eq(ItemBlacklistDetailEo::getRuleNo, (Object)eo.getRuleNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            detailEos.forEach(detailEo -> this.detailDomain.deleteById(detailEo.getId()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateState(ItemBlacklistPageReqDto dto) {
        AssertUtils.notEmpty((Collection)dto.getIds(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getRuleState(), (String)"\u9700\u8981\u66f4\u65b0\u7684\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        for (Long id : dto.getIds()) {
            ItemBlacklistEo eo = (ItemBlacklistEo)this.iItemBlacklistDomain.getMapper().findById(id);
            AssertUtils.notNull((Object)eo, (String)"\u627e\u4e0d\u5230\u8be5\u89c4\u5219");
            eo.setRuleState(dto.getRuleState());
            this.iItemBlacklistDomain.update((BaseEo)eo);
        }
    }
}

