/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.codegenerate;

import cn.hutool.core.date.DatePattern;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.yunxi.dg.base.center.inventory.dao.mapper.OrderCodeMapper;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GenerateCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(GenerateCodeUtil.class);
    @Resource
    private OrderCodeMapper orderCodeMapper;
    @Resource
    private ILockService lockService;
    @Resource
    private ICacheService cacheService;
    @Value(value="${generateCode.addTempPreFix:false}")
    private boolean ADD_TEMP_PRE_FIX;
    protected final long DEFAULT_MAX_DIGIT_NUM = 1000000000000L;

    public String generateCode(CodeGenEnum codeGenEnum) {
        try {
            return this.doGenerateCode(codeGenEnum);
        }
        catch (Exception e) {
            log.info("\u751f\u6210\u7f16\u7801\u5f02\u5e38\uff1a[lockKey:{}],eMessage:{},e:{}", new Object[]{codeGenEnum.getCode(), e.getMessage(), e});
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doGenerateCode(CodeGenEnum codeGenEnum) {
        Date date = new Date();
        String generateCodeKey = this.getGenerateCodeKey(codeGenEnum.getCode(), codeGenEnum.getCode(), date);
        log.info("doGenerateCode==>\u5b9e\u9645\u6267\u884c\u751f\u6210\u7f16\u7801\u7684,generateCodeKey:{}", (Object)generateCodeKey);
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.cacheService.getCache(generateCodeKey, String.class)))) {
            Mutex mutex;
            block3: {
                mutex = null;
                try {
                    mutex = this.lockService.lock("generateCode", codeGenEnum.getCode(), 120, 120, TimeUnit.SECONDS);
                    if (!StringUtils.isBlank((CharSequence)((CharSequence)this.cacheService.getCache(generateCodeKey, String.class)))) break block3;
                    this.cacheService.setCache(generateCodeKey, (Object)this.getMaxCode(codeGenEnum, date), 86400);
                }
                catch (Throwable throwable) {
                    Optional.ofNullable(mutex).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
                    throw throwable;
                }
            }
            Optional.ofNullable(mutex).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
        }
        long code = Optional.ofNullable(this.cacheService.incrByWithException(generateCodeKey, 1L, 86400L)).orElse(1L);
        log.info("\u67e5\u8be2\u6700\u5927\u7f16\u7801\uff1a[lockKey:{},maxCode:{}]", (Object)codeGenEnum.getCode(), (Object)code);
        AssertUtil.isTrue((code < 1000000000000L ? 1 : 0) != 0, (String)"\u8d85\u8fc7\u6700\u5927\u7f16\u7801\u9650\u5236");
        return this.doGenerateFinalCode(code, codeGenEnum, date);
    }

    public long getMaxCode(CodeGenEnum codeGenEnum, Date date) {
        String orderCode = this.loadMaxNo(codeGenEnum, date);
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            return 0L;
        }
        int length = codeGenEnum.getPrefix().length();
        int i = length + 8;
        String sequenceNumber = orderCode.substring(i).replaceAll("^0+", "");
        return this.isCurDate(() -> orderCode.substring(length, i), date) ? Long.parseLong(sequenceNumber) : 0L;
    }

    private boolean isCurDate(Supplier<String> supplier, Date date) {
        try {
            String curDate = DatePattern.PURE_DATE_FORMAT.format(date);
            String s = supplier.get();
            return Objects.equals(curDate, s);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5355\u53f7\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38:{}", (Object)e.getMessage());
            return true;
        }
    }

    private String loadMaxNo(CodeGenEnum codeGenEnum, Date date) {
        String prefix = this.getPrefix(codeGenEnum, date);
        return this.orderCodeMapper.queryMaxNoByNameAndCode(codeGenEnum.getRefTableName(), codeGenEnum.getOrderCodeName(), prefix);
    }

    @NotNull
    private String getPrefix(CodeGenEnum codeGenEnum, Date date) {
        String prefix = codeGenEnum.getPrefix() + DatePattern.PURE_DATE_FORMAT.format(date);
        if (CodeGenEnum.OUT_NOTICE_ORDER.getRefTableName().equals(codeGenEnum.getRefTableName()) && this.ADD_TEMP_PRE_FIX) {
            prefix = "U" + prefix;
        }
        return prefix;
    }

    private String getGenerateCodeKey(String tableName, String lockKey, Date date) {
        return "inventory:generateCode:" + tableName + "_" + lockKey + ":" + DatePattern.PURE_DATE_FORMAT.format(date);
    }

    private String doGenerateFinalCode(Long generateCode, CodeGenEnum codeGenEnum, Date date) {
        String codePrefix = codeGenEnum.getPrefix();
        String dateStr = DatePattern.PURE_DATE_FORMAT.format(date);
        if (StringUtils.isBlank((CharSequence)codePrefix)) {
            return dateStr + String.format("%" + codeGenEnum.getDigitNum() + "d", generateCode).replace(" ", "0");
        }
        String prefix = this.getPrefix(codeGenEnum, date);
        return prefix + String.format("%" + codeGenEnum.getDigitNum() + "d", generateCode).replace(" ", "0");
    }
}

