/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.basicdata.dto.request.PcpDictQueryReqDto;
import com.yunxi.dg.base.center.enums.ProjectEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryLogDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryOperateLogDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryLogEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryOperateLogEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.proxy.data.IPcpDictApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcAble;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcExecuteManager;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class BaseAble {
    private static final Logger log = LoggerFactory.getLogger(BaseAble.class);
    public static final String DEFAULT_BATCH = "20221221-666";
    public static final String REDIS_PRE_KEY = "dg_inventory_able_group";
    public static final String REDIS_LOGIC_WAREHOUSE_CODE_KEY = "dg_inventory_able_group_logic_warehouse_code";
    public static final String REDIS_SKU_CODE_KEY = "dg_inventory_able_group_sku_code";
    @Value(value="${mq.inventory.topic.change:SINGLE_TOPIC}")
    protected String mqInventoryChangeTopic;
    @Value(value="${mq.inventory.tag.change:INVENTORY_CHANGE_TAG}")
    protected String mqInventoryChangeTag;
    @Value(value="${mq.inventory.change.push.mode:single}")
    protected String mqInventoryChangePushMode;
    @Value(value="${inventory.update.mode:delegation}")
    protected String inventoryUpdateMode;
    @Value(value="${yunxi.dg.base.project}")
    protected String projectCode;
    private static final Cache<String, ItemSkuDto> skuDtoCache = Caffeine.newBuilder().initialCapacity(500).maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Cache<String, LogicWarehouseEo> warehouseCache = Caffeine.newBuilder().initialCapacity(100).maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    @Autowired
    ICacheService cacheService;
    @Autowired
    protected ICommonsMqService commonsMqService;
    @Autowired
    protected IContext context;
    @Autowired
    protected TransactionCallBackService transactionCallBackService;
    @Autowired
    protected IItemSkuQueryApiProxy itemSkuQueryApiProxy;
    @Autowired
    protected IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    protected ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    protected ILogicInventoryDomain logicInventoryDomain;
    @Autowired
    protected ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Autowired
    protected IInventoryOperateLogDomain inventoryOperateLogDomain;
    @Autowired
    protected IInventoryLogDomain inventoryLogDomain;
    @Autowired
    protected ICalcAble calcAble;
    @Autowired
    private IPcpDictApiProxy pcpDictApiProxy;
    @Autowired
    protected ICalcExecuteManager calcExecuteManager;

    protected void check(CalcDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getSourceNo(), (String)"\u6765\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getSourceType(), (String)"\u539f\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected void checkDetails(CalcDto dto) {
        List details = dto.getDetails();
        AssertUtils.notEmpty((Collection)details, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        Boolean projectNoneBatch = ProjectEnum.getByCode((String)this.projectCode).getNoneBatch();
        for (CalcDetailDto d : details) {
            if (projectNoneBatch.booleanValue()) {
                d.setBatch(DEFAULT_BATCH);
            }
            AssertUtils.notBlank((String)d.getSkuCode(), (String)"\u660e\u7ec6\u5546\u54c1\u7f16\u7801\u5b58\u5728\u7a7a\u503c");
            AssertUtils.notBlank((String)d.getLogicWarehouseCode(), (String)"\u660e\u7ec6\u903b\u8f91\u4ed3\u7f16\u7801\u5b58\u5728\u7a7a\u503c");
            if (!dto.getNoneBatch().booleanValue()) {
                AssertUtils.notBlank((String)d.getBatch(), (String)"\u6279\u6b21\u53f7\u5b58\u5728\u7a7a\u503c");
            }
            if (!dto.getNoneLineNo().booleanValue()) {
                AssertUtils.notNull((Object)d.getLineNo(), (String)"\u884c\u53f7\u5b58\u5728\u7a7a\u503c");
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)d.getNum()).booleanValue()) continue;
            throw new BizException(String.format("warehouseCode: %s, cargoCode: %s, \u4ed3\u5e93\u53d8\u5316\u91cf\u4e0d\u5b58\u5728\u6216\u8005\u4e3a0", d.getLogicWarehouseCode(), d.getSkuCode()));
        }
    }

    protected void checkDetails(List<CalcDetailDto> details) {
        AssertUtils.notEmpty(details, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        Boolean projectNoneBatch = ProjectEnum.getByCode((String)this.projectCode).getNoneBatch();
        for (CalcDetailDto d : details) {
            if (projectNoneBatch.booleanValue()) {
                d.setBatch(DEFAULT_BATCH);
            }
            AssertUtils.notBlank((String)d.getSkuCode(), (String)"\u660e\u7ec6\u5546\u54c1\u7f16\u7801\u5b58\u5728\u7a7a\u503c");
            AssertUtils.notBlank((String)d.getLogicWarehouseCode(), (String)"\u660e\u7ec6\u903b\u8f91\u4ed3\u7f16\u7801\u5b58\u5728\u7a7a\u503c");
            if (!BigDecimalUtils.eqZero((BigDecimal)d.getNum()).booleanValue()) continue;
            throw new BizException(String.format("warehouseCode: %s, cargoCode: %s, \u4ed3\u5e93\u53d8\u5316\u91cf\u4e0d\u5b58\u5728\u6216\u8005\u4e3a0", d.getLogicWarehouseCode(), d.getSkuCode()));
        }
    }

    protected List<LogicWarehouseEo> queryEnableLogicWarehouseByCodes(List<String> logicWarehouseCodes) {
        ArrayList warehouseCodes = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)warehouseCodes, logicWarehouseCodes, String.class);
        Map<String, LogicWarehouseEo> redisWarehouseMapEos = this.getWarehouseCache(warehouseCodes);
        ArrayList redisChannelWarehouseEos = Lists.newArrayList(redisWarehouseMapEos.values());
        redisChannelWarehouseEos.removeIf(Objects::isNull);
        log.info("LogicWarehouse codes \u7f13\u5b58\u547d\u4e2d\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)redisChannelWarehouseEos));
        redisChannelWarehouseEos.removeIf(o -> ValidFlagEnum.DISABLE.getCode().equals(o.getWarehouseStatus()));
        warehouseCodes.removeIf(o -> null != redisChannelWarehouseEos.stream().filter(c -> StringUtils.equals((CharSequence)o, (CharSequence)c.getWarehouseCode())).findFirst().orElse(null));
        log.info("LogicWarehouse codes \u672a\u547d\u4e2d\u7f13\u5b58codes: {}", (Object)warehouseCodes);
        if (CollectionUtil.isNotEmpty((Collection)warehouseCodes)) {
            List warehouseEos = this.logicWarehouseDomain.queryByCodes((List)warehouseCodes);
            AssertUtils.notEmpty((Collection)warehouseEos, (String)"\u660e\u7ec6\u5bf9\u5e94\u903b\u8f91\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
            HashMap putRedisMap = Maps.newHashMap();
            for (LogicWarehouseEo warehouseEo : warehouseEos) {
                redisChannelWarehouseEos.add(warehouseEo);
                putRedisMap.put(warehouseEo.getWarehouseCode(), JSON.toJSONString((Object)warehouseEo));
                warehouseCache.put((Object)warehouseEo.getWarehouseCode(), (Object)warehouseEo);
            }
            this.cacheService.hmset(REDIS_LOGIC_WAREHOUSE_CODE_KEY, (Map)putRedisMap);
            log.info("LogicWarehouse code: {}, \u5199\u5165Redis\u7ed3\u679c", (Object)warehouseCodes);
        }
        return redisChannelWarehouseEos;
    }

    private Map<String, LogicWarehouseEo> getWarehouseCache(List<String> warehouseCodes) {
        Map redisCache;
        Map allPresent = warehouseCache.getAllPresent(warehouseCodes);
        warehouseCodes.removeIf(allPresent::containsKey);
        HashMap<String, LogicWarehouseEo> resultMap = new HashMap<String, LogicWarehouseEo>();
        if (CollectionUtil.isNotEmpty((Map)allPresent)) {
            resultMap.putAll(allPresent);
        }
        if (CollectionUtils.isNotEmpty(warehouseCodes) && !(redisCache = this.cacheService.hmget(REDIS_LOGIC_WAREHOUSE_CODE_KEY, warehouseCodes.toArray(new String[0]), LogicWarehouseEo.class)).isEmpty()) {
            redisCache.entrySet().stream().filter(r -> Objects.nonNull(r.getValue())).forEach(entry -> {
                warehouseCache.put(entry.getKey(), entry.getValue());
                resultMap.put((String)entry.getKey(), (LogicWarehouseEo)entry.getValue());
            });
        }
        return resultMap;
    }

    protected List<ItemSkuDto> queryItemSkuListByCodes(List<String> skuCodes) {
        if (CollectionUtil.isEmpty(skuCodes)) {
            return Lists.newArrayList();
        }
        skuCodes = skuCodes.stream().filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList copySkuCodes = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)copySkuCodes, skuCodes, String.class);
        Map<String, ItemSkuDto> redisCargoMapEos = this.getItemCacheMap(copySkuCodes);
        ArrayList redisSkuDtoList = Lists.newArrayList(redisCargoMapEos.values());
        redisSkuDtoList.removeIf(Objects::isNull);
        log.info("ItemSkuDto codes \u7f13\u5b58\u547d\u4e2d\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)redisSkuDtoList));
        copySkuCodes.removeIf(o -> null != redisSkuDtoList.stream().filter(c -> StringUtils.equals((CharSequence)o, (CharSequence)c.getSkuCode())).findFirst().orElse(null));
        log.info("ItemSkuDto codes \u672a\u547d\u4e2d\u7f13\u5b58codes: {}", (Object)copySkuCodes);
        if (CollectionUtil.isNotEmpty((Collection)copySkuCodes)) {
            List skuDtoList = this.itemSkuQueryApiProxy.queryBySkuCodes((List)copySkuCodes);
            AssertUtils.notEmpty((Collection)skuDtoList, (String)"\u660e\u7ec6\u5bf9\u5e94\u8d27\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            HashMap putRedisMap = Maps.newHashMap();
            for (ItemSkuDto itemSkuDto : skuDtoList) {
                redisSkuDtoList.add(itemSkuDto);
                skuDtoCache.put((Object)itemSkuDto.getSkuCode(), (Object)itemSkuDto);
            }
            this.cacheService.hmset(REDIS_SKU_CODE_KEY, (Map)putRedisMap);
            log.info("sku code: {}, \u5199\u5165Redis\u7ed3\u679c", (Object)copySkuCodes);
        }
        return redisSkuDtoList;
    }

    private Map<String, ItemSkuDto> getItemCacheMap(List<String> copySkuCodes) {
        Map redisCache;
        Map allPresent = skuDtoCache.getAllPresent(copySkuCodes);
        copySkuCodes.removeIf(allPresent::containsKey);
        HashMap<String, ItemSkuDto> resultMap = new HashMap<String, ItemSkuDto>();
        if (CollectionUtil.isNotEmpty((Map)allPresent)) {
            resultMap.putAll(allPresent);
        }
        if (CollectionUtils.isNotEmpty(copySkuCodes) && !(redisCache = this.cacheService.hmget(REDIS_SKU_CODE_KEY, copySkuCodes.toArray(new String[0]), ItemSkuDto.class)).isEmpty()) {
            redisCache.entrySet().stream().filter(r -> Objects.nonNull(r.getValue())).forEach(entry -> {
                skuDtoCache.put(entry.getKey(), entry.getValue());
                resultMap.put((String)entry.getKey(), (ItemSkuDto)entry.getValue());
            });
        }
        return resultMap;
    }

    protected List<LogicInventoryEo> queryLogicInventoryEos(List<ItemSkuDto> itemSkuDtoList, List<LogicWarehouseEo> logicWarehouseEos, List<String> batches, Set<String> hasKeys) {
        List skuCodes = itemSkuDtoList.stream().map(ItemSkuDto::getSkuCode).distinct().collect(Collectors.toList());
        List logicWarehouseCodes = logicWarehouseEos.stream().map(LogicWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List logicInventoryEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().in((Object)"warehouse_code", logicWarehouseCodes)).in((Object)"sku_code", skuCodes)).in(CollectionUtils.isNotEmpty(batches), (Object)"batch", batches)).list();
        batches.removeIf(StringUtils::isEmpty);
        if (CollectionUtil.isEmpty(itemSkuDtoList) || CollectionUtil.isEmpty(batches)) {
            return logicInventoryEos;
        }
        ArrayList insertLogicInventoryEos = Lists.newArrayList();
        for (LogicWarehouseEo logicWarehouseEo : logicWarehouseEos) {
            for (ItemSkuDto itemSkuDto : itemSkuDtoList) {
                for (String batch : batches) {
                    LogicInventoryEo logicInventoryEo;
                    String key = StrUtil.join((CharSequence)InventoryConfig.getCommonSeparate(), (Object[])new Object[]{logicWarehouseEo.getWarehouseCode(), itemSkuDto.getSkuCode(), batch});
                    if (!hasKeys.contains(key) || null != (logicInventoryEo = (LogicInventoryEo)logicInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)logicWarehouseEo.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)itemSkuDto.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)batch)).findFirst().orElse(null))) continue;
                    LogicInventoryEo insertLogicInventoryEo = this.initLogicInventory(logicWarehouseEo, itemSkuDto, batch);
                    insertLogicInventoryEos.add(insertLogicInventoryEo);
                }
            }
        }
        List logicInventoryEoList = this.logicInventoryDomain.batchIgnoreInsertNew((List)insertLogicInventoryEos);
        if (ObjectUtil.equals((Object)logicInventoryEoList.size(), (Object)insertLogicInventoryEos.size())) {
            logicInventoryEos.addAll(insertLogicInventoryEos);
        } else {
            int retryCount;
            logicInventoryEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().in((Object)"warehouse_code", logicWarehouseCodes)).in((Object)"sku_code", skuCodes)).in((Object)"batch", batches)).list();
            for (retryCount = 20; hasKeys.size() > logicInventoryEos.size() && retryCount > 0; --retryCount) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new BizException(e.getMessage());
                }
                logicInventoryEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().in((Object)"warehouse_code", logicWarehouseCodes)).in((Object)"sku_code", skuCodes)).in((Object)"batch", batches)).list();
            }
            log.info("\u5269\u4f59\u68c0\u67e5 {} \u6b21\uff0c \u6bcf\u6b21\u7b49\u5f85 50ms \u6267\u884c\u5b8c\u6210 inventory \u63d2\u5165\u67e5\u8be2\u7b49\u5f85", (Object)retryCount);
        }
        return logicInventoryEos;
    }

    protected List<LogicInventoryEo> queryLogicInventoryEos(List<ItemSkuDto> itemSkuDtoList, List<LogicWarehouseEo> logicWarehouseEos, List<String> batches) {
        HashSet hasKeys = Sets.newHashSet();
        for (LogicWarehouseEo logicWarehouseEo : logicWarehouseEos) {
            for (ItemSkuDto itemSkuDto : itemSkuDtoList) {
                for (String batch : batches) {
                    hasKeys.add(StrUtil.join((CharSequence)InventoryConfig.getCommonSeparate(), (Object[])new Object[]{logicWarehouseEo.getWarehouseCode(), itemSkuDto.getSkuCode(), batch}));
                }
            }
        }
        return this.queryLogicInventoryEos(itemSkuDtoList, logicWarehouseEos, batches, hasKeys);
    }

    protected List<LogicInventoryTotalEo> queryLogicInventoryTotalEos(List<ItemSkuDto> itemSkuDtoList, List<LogicWarehouseEo> logicWarehouseEos) {
        List skuCodes = itemSkuDtoList.stream().map(ItemSkuDto::getSkuCode).distinct().collect(Collectors.toList());
        List logicWarehouseCodes = logicWarehouseEos.stream().map(LogicWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List logicInventoryTotalEos = this.logicInventoryTotalDomain.queryByWarehouseCodesAndSkuCodes(logicWarehouseCodes, skuCodes);
        if (CollectionUtil.isEmpty(itemSkuDtoList)) {
            log.info(Thread.currentThread().getName() + "\u903b\u8f91\u5e93\u5b58:{}", (Object)JSONObject.toJSONString((Object)logicInventoryTotalEos));
            return logicInventoryTotalEos;
        }
        ArrayList insertLogicInventoryTotalEos = Lists.newArrayList();
        for (LogicWarehouseEo logicWarehouseEo : logicWarehouseEos) {
            for (ItemSkuDto itemSkuDto : itemSkuDtoList) {
                LogicInventoryTotalEo logicInventoryTotalEo = logicInventoryTotalEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)logicWarehouseEo.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)itemSkuDto.getSkuCode())).findFirst().orElse(null);
                if (null != logicInventoryTotalEo) continue;
                LogicInventoryTotalEo insertLogicInventoryTotalEo = this.initLogicInventoryTotal(logicWarehouseEo, itemSkuDto);
                insertLogicInventoryTotalEos.add(insertLogicInventoryTotalEo);
            }
        }
        int planCount = insertLogicInventoryTotalEos.size() + logicInventoryTotalEos.size();
        List doInsertLogicInventoryTotalEos = this.logicInventoryTotalDomain.batchIgnoreInsertNew((List)insertLogicInventoryTotalEos);
        if (doInsertLogicInventoryTotalEos.size() >= insertLogicInventoryTotalEos.size()) {
            logicInventoryTotalEos.addAll(insertLogicInventoryTotalEos);
        } else {
            int retryCount;
            logicInventoryTotalEos = this.logicInventoryTotalDomain.queryByWarehouseCodesAndSkuCodes(logicWarehouseCodes, skuCodes);
            for (retryCount = 20; planCount > logicInventoryTotalEos.size() && retryCount > 0; --retryCount) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new BizException(e.getMessage());
                }
                logicInventoryTotalEos = this.logicInventoryTotalDomain.queryByWarehouseCodesAndSkuCodes(logicWarehouseCodes, skuCodes);
            }
            log.info("\u5269\u4f59\u68c0\u67e5 {} \u6b21\uff0c \u6bcf\u6b21\u7b49\u5f85 50ms \u6267\u884c\u5b8c\u6210 total inventory \u63d2\u5165\u67e5\u8be2\u7b49\u5f85", (Object)retryCount);
        }
        return logicInventoryTotalEos;
    }

    private LogicInventoryEo initLogicInventory(LogicWarehouseEo warehouseEo, ItemSkuDto skuDto, String batch) {
        if (StringUtils.isBlank((CharSequence)batch) || StringUtils.equals((CharSequence)batch, (CharSequence)"null")) {
            throw new BizException("\u63d2\u5165\u5e93\u5b58\u660e\u7ec6\u6570\u636e\uff0c\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String currentUserName = StrUtil.isBlank((CharSequence)this.context.userName()) ? "system" : this.context.userName();
        LogicInventoryEo logicInventoryEo = new LogicInventoryEo();
        logicInventoryEo.setId(Long.valueOf(IdWorker.getId()));
        logicInventoryEo.setWarehouseId(warehouseEo.getId());
        logicInventoryEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        logicInventoryEo.setWarehouseName(warehouseEo.getWarehouseName());
        logicInventoryEo.setSkuCode(skuDto.getSkuCode());
        logicInventoryEo.setSkuName(skuDto.getSkuName());
        logicInventoryEo.setBatch(batch);
        logicInventoryEo.setIntransit(BigDecimal.ZERO);
        logicInventoryEo.setBalance(BigDecimal.ZERO);
        logicInventoryEo.setAvailable(BigDecimal.ZERO);
        logicInventoryEo.setPreempt(BigDecimal.ZERO);
        logicInventoryEo.setActivityAllocate(BigDecimal.ZERO);
        logicInventoryEo.setAllocate(BigDecimal.ZERO);
        logicInventoryEo.setCompleted(BigDecimal.ZERO);
        logicInventoryEo.setFutureIn(BigDecimal.ZERO);
        logicInventoryEo.setFutureRetreat(BigDecimal.ZERO);
        logicInventoryEo.setTransfer(BigDecimal.ZERO);
        logicInventoryEo.setLockInventory(BigDecimal.ZERO);
        logicInventoryEo.setDr(YesNoHelper.NO);
        logicInventoryEo.setCreatePerson(currentUserName);
        logicInventoryEo.setUpdatePerson(currentUserName);
        return logicInventoryEo;
    }

    private LogicInventoryTotalEo initLogicInventoryTotal(LogicWarehouseEo warehouseEo, ItemSkuDto skuDto) {
        String currentUserName = StrUtil.isBlank((CharSequence)this.context.userName()) ? "system" : this.context.userName();
        LogicInventoryTotalEo logicInventoryTotalEo = new LogicInventoryTotalEo();
        logicInventoryTotalEo.setId(Long.valueOf(IdWorker.getId()));
        logicInventoryTotalEo.setWarehouseId(warehouseEo.getId());
        logicInventoryTotalEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        logicInventoryTotalEo.setWarehouseName(warehouseEo.getWarehouseName());
        logicInventoryTotalEo.setSkuCode(skuDto.getSkuCode());
        logicInventoryTotalEo.setSkuName(skuDto.getSkuName());
        logicInventoryTotalEo.setIntransit(BigDecimal.ZERO);
        logicInventoryTotalEo.setBalance(BigDecimal.ZERO);
        logicInventoryTotalEo.setAvailable(BigDecimal.ZERO);
        logicInventoryTotalEo.setPreempt(BigDecimal.ZERO);
        logicInventoryTotalEo.setActivityAllocate(BigDecimal.ZERO);
        logicInventoryTotalEo.setAllocate(BigDecimal.ZERO);
        logicInventoryTotalEo.setCompleted(BigDecimal.ZERO);
        logicInventoryTotalEo.setFutureIn(BigDecimal.ZERO);
        logicInventoryTotalEo.setFutureRetreat(BigDecimal.ZERO);
        logicInventoryTotalEo.setTransfer(BigDecimal.ZERO);
        logicInventoryTotalEo.setLockInventory(BigDecimal.ZERO);
        logicInventoryTotalEo.setDr(YesNoHelper.NO);
        logicInventoryTotalEo.setCreatePerson(currentUserName);
        logicInventoryTotalEo.setUpdatePerson(currentUserName);
        return logicInventoryTotalEo;
    }

    protected String getKey(String warehouseCode, String skuCode, String batch) {
        return String.format("%s_%s_%s", warehouseCode, skuCode, batch);
    }

    protected String getTotalKey(String warehouseCode, String skuCode) {
        return String.format("%s_%s", warehouseCode, skuCode);
    }

    protected void doCalc(CalcInventoryDto logicCalcDto, CalcInventoryDto logicTotalCalcDto, List<LogicWarehouseEo> logicWarehouseEos, List<LogicInventoryEo> logicInventoryEos, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
        boolean noneBatch = InventoryConfig.isNoneBatch();
        if (!noneBatch) {
            this.calcAble.calcLogic(logicCalcDto, logicWarehouseEos, logicInventoryEos);
        }
        this.calcAble.calcLogicTotal(logicTotalCalcDto, logicWarehouseEos, logicInventoryTotalEos);
        ArrayList operateLogEos = Lists.newArrayList();
        ArrayList logEos = Lists.newArrayList();
        if (!noneBatch) {
            this.calcAble.createLogicLogs(logicCalcDto, logicWarehouseEos, logicInventoryEos, operateLogEos, logEos);
        }
        this.calcAble.createLogicTotalLogs(logicTotalCalcDto, logicWarehouseEos, logicInventoryTotalEos, operateLogEos, logEos);
        this.saveLog(operateLogEos, logEos);
    }

    private void setOperateLogDocument(List<InventoryOperateLogEo> operateLogEos) {
        if (CollUtil.isEmpty(operateLogEos)) {
            return;
        }
        Set businessTypeSet = operateLogEos.stream().map(InventoryOperateLogEo::getBusinessType).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        if (CollUtil.isEmpty(businessTypeSet)) {
            return;
        }
        PcpDictQueryReqDto pcpDictQueryReqDto = new PcpDictQueryReqDto();
        pcpDictQueryReqDto.setCodeList((List)Lists.newArrayList(businessTypeSet));
        List dictDtoList = null;
        try {
            RestResponse dtoRestResponse = this.pcpDictApiProxy.queryByParam(pcpDictQueryReqDto);
            dictDtoList = (List)RestResponseHelper.extractData((RestResponse)dtoRestResponse);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u914d\u7f6e\u5f02\u5e38:{}", (Object)e.getMessage());
            return;
        }
        if (CollUtil.isEmpty((Collection)dictDtoList)) {
            return;
        }
        block2: for (InventoryOperateLogEo operateLogEo : operateLogEos) {
            String documentCode;
            String businessType = operateLogEo.getBusinessType();
            if (StrUtil.isBlank((CharSequence)businessType) || StrUtil.isNotBlank((CharSequence)(documentCode = operateLogEo.getDocumentCode()))) continue;
            for (DictDto dictDto : dictDtoList) {
                if (!StrUtil.equals((CharSequence)businessType, (CharSequence)dictDto.getCode())) continue;
                operateLogEo.setDocumentCode(dictDto.getGroupCode());
                operateLogEo.setDocumentName(dictDto.getStatement());
                continue block2;
            }
        }
    }

    protected void doBatchCalc(List<CalcInventoryDto> logicCalcDtoList, List<CalcInventoryDto> logicTotalCalcDtoList, List<LogicWarehouseEo> logicWarehouseEos, List<LogicInventoryEo> logicInventoryEos, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
        this.calcAble.calcBatchLogic(logicCalcDtoList, logicWarehouseEos, logicInventoryEos);
        this.calcAble.calcBatchLogicTotal(logicTotalCalcDtoList, logicWarehouseEos, logicInventoryTotalEos);
        ArrayList operateLogEos = Lists.newArrayList();
        ArrayList logEos = Lists.newArrayList();
        for (CalcInventoryDto calcInventoryDto : logicCalcDtoList) {
            this.calcAble.createLogicLogs(calcInventoryDto, logicWarehouseEos, logicInventoryEos, operateLogEos, logEos);
        }
        for (CalcInventoryDto calcInventoryDto : logicTotalCalcDtoList) {
            this.calcAble.createLogicTotalLogs(calcInventoryDto, logicWarehouseEos, logicInventoryTotalEos, operateLogEos, logEos);
        }
        this.saveLog(operateLogEos, logEos);
    }

    protected void saveLog(List<InventoryOperateLogEo> operateLogEos, List<InventoryLogEo> logEos) {
        if (CollectionUtil.isNotEmpty(operateLogEos)) {
            this.transactionCallBackService.execute(() -> {
                log.info("inventoryOperateLogInsertBatch \u4e1a\u52a1\u5355\u53f7\uff1a{} \u751f\u6210\u6d41\u6c34", (Object)((InventoryOperateLogEo)operateLogEos.get(0)).getSourceNo());
                this.setOperateLogDocument(operateLogEos);
                this.inventoryOperateLogDomain.insertBatch(operateLogEos);
                this.inventoryLogDomain.insertBatch(logEos);
                if (CollectionUtil.isNotEmpty((Collection)operateLogEos)) {
                    this.calcAble.sendInventoryLogs(logEos);
                }
            });
        }
    }

    protected CalcInventoryDto createCalcLogicTotalDtoByLogicDto(CalcInventoryDto logicCalcDto) {
        CalcInventoryDto logicTotalCalcDto = new CalcInventoryDto();
        BeanUtils.copyProperties((Object)logicCalcDto, (Object)logicTotalCalcDto, (String[])new String[]{"details"});
        HashMap map = Maps.newHashMap();
        for (CalcInventoryDetailDto logicDetail : logicCalcDto.getDetails()) {
            String totalKey = this.getTotalKey(logicDetail.getWarehouseCode(), logicDetail.getSkuCode());
            CalcInventoryDetailDto logicTotalDetail = map.getOrDefault(totalKey, new CalcInventoryDetailDto());
            logicTotalDetail.setOperate(logicDetail.getOperate());
            logicTotalDetail.setChangeBalance(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangeBalance(), (BigDecimal)logicDetail.getChangeBalance()));
            logicTotalDetail.setChangeAvailable(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangeAvailable(), (BigDecimal)logicDetail.getChangeAvailable()));
            logicTotalDetail.setChangePreempt(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangePreempt(), (BigDecimal)logicDetail.getChangePreempt()));
            logicTotalDetail.setChangeAllocate(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangeAllocate(), (BigDecimal)logicDetail.getChangeAllocate()));
            logicTotalDetail.setChangeIntransit(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangeIntransit(), (BigDecimal)logicDetail.getChangeIntransit()));
            logicTotalDetail.setChangeFutureIn(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangeFutureIn(), (BigDecimal)logicDetail.getChangeFutureIn()));
            logicTotalDetail.setChangeLockInventory(BigDecimalUtils.add((BigDecimal)logicTotalDetail.getChangeLockInventory(), (BigDecimal)logicDetail.getChangeLockInventory()));
            logicTotalDetail.setWarehouseCode(logicDetail.getWarehouseCode());
            logicTotalDetail.setSkuCode(logicDetail.getSkuCode());
            logicTotalDetail.setValidNegative(logicDetail.getValidNegative());
            logicTotalDetail.setLendInventory(BigDecimalUtils.add((BigDecimal)logicDetail.getLendInventory(), (BigDecimal)logicTotalDetail.getLendInventory()));
            map.put(totalKey, logicTotalDetail);
        }
        logicTotalCalcDto.setDetails((List)Lists.newArrayList(map.values()));
        return logicTotalCalcDto;
    }

    protected List<CalcDetailDto> updatePreempt(List<CalcDetailDto> details, List<InventoryPreemptionEo> inventoryPreemptionEos) {
        return this.updatePreempt(details, inventoryPreemptionEos, true);
    }

    protected List<CalcDetailDto> updatePreempt(List<CalcDetailDto> details, List<InventoryPreemptionEo> inventoryPreemptionEos, Boolean isAllRelease) {
        if (CollectionUtil.isEmpty(inventoryPreemptionEos)) {
            return Lists.newArrayList();
        }
        String mapKeyStr = "%s_%s_%s";
        Map calcDetailDtoMap = details.stream().collect(Collectors.toMap(o -> String.format(mapKeyStr, o.getLineNo(), o.getSkuCode(), o.getBatch()), Function.identity()));
        ArrayList updatePreemptionEoList = Lists.newArrayList();
        ArrayList releaseDetails = Lists.newArrayList();
        for (InventoryPreemptionEo preemptionEo : inventoryPreemptionEos) {
            String key = String.format(mapKeyStr, preemptionEo.getLineNo(), preemptionEo.getSkuCode(), preemptionEo.getBatch());
            CalcDetailDto detailDto = (CalcDetailDto)calcDetailDtoMap.get(key);
            if (isAllRelease.booleanValue()) {
                preemptionEo.setReleaseNum(preemptionEo.getPreemptNum());
            } else {
                if (null == detailDto) continue;
                preemptionEo.setReleaseNum(BigDecimalUtils.add((BigDecimal)preemptionEo.getReleaseNum(), (BigDecimal)detailDto.getNum()));
            }
            if (BigDecimalUtils.lt((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum()).booleanValue()) {
                throw new BizException("\u5df2\u8d85\u9884\u5360\u91ca\u653e");
            }
            if (BigDecimalUtils.equals((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum()).booleanValue()) {
                preemptionEo.setValid(ValidFlagEnum.DISABLE.getCode());
            }
            CalcDetailDto releaseDetail = new CalcDetailDto();
            releaseDetail.setLineNo(preemptionEo.getLineNo());
            releaseDetail.setSkuCode(preemptionEo.getSkuCode());
            releaseDetail.setBatch(preemptionEo.getBatch());
            releaseDetail.setLogicWarehouseCode(preemptionEo.getWarehouseCode());
            releaseDetail.setPreOrderItemId(preemptionEo.getPreOrderItemId());
            if (isAllRelease.booleanValue()) {
                releaseDetail.setNum(preemptionEo.getPreemptNum());
            }
            releaseDetails.add(releaseDetail);
            updatePreemptionEoList.add(preemptionEo);
        }
        this.inventoryPreemptionDomain.updatePreempt((List)updatePreemptionEoList);
        return releaseDetails;
    }

    protected List<LogicWarehouseEo> getLogicWarehouseEosAndCheck(List<CalcDetailDto> details) {
        List<String> logicWarehouseCodes = details.stream().map(CalcDetailDto::getLogicWarehouseCode).distinct().collect(Collectors.toList());
        List<LogicWarehouseEo> logicWarehouseEos = this.queryEnableLogicWarehouseByCodes(logicWarehouseCodes);
        AssertUtils.notEmpty(logicWarehouseEos, (String)"\u903b\u8f91\u4ed3[%s]\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object[])new Object[]{logicWarehouseCodes});
        return logicWarehouseEos;
    }

    protected void checkSku(List<CalcDetailDto> details) {
        List<String> skuCodes = details.stream().map(CalcDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(skuCodes);
        AssertUtils.notEmpty(skuDtoList, (String)"\u8d27\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
    }
}

