/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.abstracts;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.CsPlannedOrderItemStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInOutResultOrderAble
implements InOutResultOrderAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractInOutResultOrderAble.class);
    @Resource
    GenerateCodeUtil generateCodeUtil;
    @Resource
    protected IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    protected IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;

    @Override
    public void doGenerate(InOutResultOrderContext context) {
        log.info("\u751f\u6210\u5165\u51fa\u5e93\u7ed3\u679c\u5355,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)context));
        InOutResultOrderEo outResultOrderEo = this.getInOutResultOrderEo(context);
        List<InOutResultOrderDetailEo> detailEoList = this.getInOutResultOrderDetailEos(context, outResultOrderEo);
        context.setInOutResultOrderEo(outResultOrderEo);
        context.setInOutResultOrderDetailEoList(detailEoList);
        this.wrapperGenerate(context);
        context.execBefore();
        log.info("\u751f\u6210\u5165\u51fa\u5e93\u7ed3\u679c\u5355,\u53c2\u6570context:{}", (Object)JSON.toJSONString((Object)context));
        if (context.isHangup()) {
            outResultOrderEo.setOrderStatus(this.getHangUpStatus());
        }
        this.inOutResultOrderDomain.insert((BaseEo)context.getInOutResultOrderEo());
        this.inOutResultOrderDetailDomain.insertBatch(context.getInOutResultOrderDetailEoList());
        if (context.isHangup()) {
            return;
        }
        context.execAfter();
        this.wrapperGenerateAfter(context);
    }

    protected abstract String getHangUpStatus();

    protected abstract void wrapperGenerate(InOutResultOrderContext var1);

    protected abstract void wrapperGenerateAfter(InOutResultOrderContext var1);

    private InOutResultOrderEo getInOutResultOrderEo(InOutResultOrderContext context) {
        InOutResultOrderEo outResultOrderEo = Optional.ofNullable(context.getInOutResultOrderEo()).orElse(new InOutResultOrderEo());
        context.setDocumentNo(this.getDocumentNo(context));
        BeanUtil.copyProperties((Object)context, (Object)outResultOrderEo, (String[])new String[]{"wmsOrderNo"});
        if (StringUtils.isNotBlank((CharSequence)context.getWmsOrderNo())) {
            outResultOrderEo.setWmsOrderNo(context.getWmsOrderNo());
        }
        outResultOrderEo.setOcsConsignmentNo(context.getOcsConsignmentNo());
        outResultOrderEo.setRelevanceTableName(context.getRelevanceTableName().getCode());
        outResultOrderEo.setOrderStatus(context.getOrderStatus().getCode());
        outResultOrderEo.setOrderType(BaseOrderOperateTypeEnum.OUT.equals((Object)context.getOperateTypeEnum()) ? "out" : "in");
        outResultOrderEo.setTotalQuantity(context.getTotalQuantity() == null ? BigDecimal.ZERO : context.getTotalQuantity());
        outResultOrderEo.setRemark(context.getRemark());
        outResultOrderEo.setExtension(context.getExtension());
        outResultOrderEo.setTotalVolume(context.getTotalVolume());
        outResultOrderEo.setTotalWeight(context.getTotalWeight());
        if (CollectionUtils.isNotEmpty(context.getShippingInfoReqDtoList())) {
            List consignNoList = context.getShippingInfoReqDtoList().stream().map(CsWmsShippingInfoReqDto::getConsignNo).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(consignNoList)) {
                String consignNo = String.join((CharSequence)",", consignNoList);
                outResultOrderEo.setConsignmentNo(consignNo);
            }
            Optional.ofNullable(context.getShippingInfoReqDtoList()).filter(CollectionUtils::isNotEmpty).ifPresent(shippingInfoReqDtoList -> {
                CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0);
                outResultOrderEo.setShippingCode(csWmsShippingInfoReqDto.getShippingNo());
                outResultOrderEo.setShippingCompanyCode(csWmsShippingInfoReqDto.getShippingCompanyCode());
                outResultOrderEo.setShippingCompany(csWmsShippingInfoReqDto.getShippingCompanyName());
                outResultOrderEo.setShippingJson(JSON.toJSONString((Object)shippingInfoReqDtoList));
            });
        }
        return outResultOrderEo;
    }

    private String getDocumentNo(InOutResultOrderContext context) {
        if (BaseOrderOperateTypeEnum.OUT.equals((Object)context.getOperateTypeEnum())) {
            return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.OUT_RESULT_ORDER.getCode()));
        }
        return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.IN_RESULT_ORDER.getCode()));
    }

    private List<InOutResultOrderDetailEo> getInOutResultOrderDetailEos(InOutResultOrderContext context, InOutResultOrderEo outResultOrderEo) {
        List<BaseOrderDetailReqDto> reqDtoList = context.getOrderBasicsDetailReqDtoList();
        ArrayList<InOutResultOrderDetailEo> detailEoList = new ArrayList<InOutResultOrderDetailEo>(reqDtoList.size());
        Map<String, List<BaseOrderDetailReqDto>> listMap = reqDtoList.stream().collect(Collectors.groupingBy(this::groupingByKey));
        listMap.forEach((key, detailList) -> {
            InOutResultOrderDetailEo detailEo = new InOutResultOrderDetailEo();
            BaseOrderDetailReqDto d = (BaseOrderDetailReqDto)detailList.get(0);
            BigDecimal quantity = detailList.stream().map(BaseOrderDetailReqDto::getQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal weight = detailList.stream().map(BaseOrderDetailReqDto::getWeight).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal volume = detailList.stream().map(BaseOrderDetailReqDto::getVolume).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal dispatcherQuantity = detailList.stream().map(BaseOrderDetailReqDto::getDispatcherQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (CollectionUtils.isNotEmpty(d.getSnCodes())) {
                detailEo.setSnCode(StringUtils.join(d.getSnCodes(), (String)","));
            }
            Optional.ofNullable(context.getShippingInfoReqDtoList()).filter(CollectionUtils::isNotEmpty).ifPresent(shippingInfoReqDtoList -> detailEo.setShippingCode(StringUtils.join((Iterable)shippingInfoReqDtoList.stream().map(CsWmsShippingInfoReqDto::getShippingNo).collect(Collectors.toList()), (String)",")));
            detailEo.setSkuCode(d.getSkuCode());
            detailEo.setSkuName(d.getSkuName());
            detailEo.setLineNo(d.getLineNo());
            detailEo.setBatch(d.getBatch());
            detailEo.setDocumentNo(outResultOrderEo.getDocumentNo());
            detailEo.setPreOrderItemId(d.getPreOrderItemId());
            detailEo.setPlanQuantity(quantity);
            detailEo.setWaitQuantity(BigDecimal.ZERO);
            detailEo.setCancelQuantity(BigDecimal.ZERO);
            detailEo.setDoneQuantity(quantity);
            detailEo.setQuantity(quantity);
            detailEo.setExternalOrderNo(context.getExternalOrderNo());
            detailEo.setPreOrderNo(context.getPreOrderNo());
            detailEo.setRelevanceNo(context.getRelevanceNo());
            detailEo.setInitFlag(YesNoEnum.YES.getValue());
            detailEo.setExtension(d.getExtension());
            detailEo.setDispatcherQuantity(dispatcherQuantity);
            detailEo.setDispatcherStatus(d.getDispatcherStatus());
            detailEo.setItemStatus(StringUtils.isNotBlank((CharSequence)d.getItemStatus()) ? d.getItemStatus() : CsPlannedOrderItemStatusEnum.COMMON.getCode());
            detailEo.setProduceTime(d.getProduceTime());
            detailEo.setExpireTime(d.getExpireTime());
            detailEo.setWeight(weight);
            detailEo.setVolume(volume);
            detailEoList.add(detailEo);
        });
        return detailEoList;
    }

    private String groupingByKey(BaseOrderDetailReqDto eo) {
        return eo.getSkuCode() + eo.getBatch() + eo.getPreOrderItemId();
    }

    @Override
    public void close(InOutResultOrderContext context) {
    }

    @Override
    public void hangUp(InOutResultOrderContext inOutResultOrderContext) {
    }

    protected abstract String getCompleteStatus();

    @Override
    public void unhook(InOutResultOrderContext inOutResultOrderContext) {
        InOutResultOrderEo inOutResultOrderEo = inOutResultOrderContext.getInOutResultOrderEo();
        this.setUnhookWarehouse(inOutResultOrderContext);
        List<InOutResultOrderDetailEo> inOutResultOrderEoList = inOutResultOrderContext.getInOutResultOrderDetailEoList();
        if (CollectionUtils.isNotEmpty(inOutResultOrderContext.getOrderBasicsDetailReqDtoList())) {
            Map<Long, BigDecimal> planQuantityMap = inOutResultOrderEoList.stream().collect(Collectors.toMap(BaseEo::getId, InOutResultOrderDetailEo::getPlanQuantity));
            List updateList = inOutResultOrderContext.getOrderBasicsDetailReqDtoList().stream().map(r -> {
                InOutResultOrderDetailEo inOutResultOrderDetailEo = new InOutResultOrderDetailEo();
                inOutResultOrderDetailEo.setId(r.getRelateId());
                BigDecimal decimal = (BigDecimal)planQuantityMap.get(r.getRelateId());
                AssertUtils.isTrue((boolean)Objects.nonNull(decimal), (String)("id\u5f02\u5e38:" + r.getRelateId()));
                inOutResultOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
                inOutResultOrderDetailEo.setDoneQuantity(r.getQuantity());
                return inOutResultOrderDetailEo;
            }).collect(Collectors.toList());
            this.inOutResultOrderDetailDomain.getMapper().updateBatchByIds(updateList);
        }
        InOutResultOrderEo updateEo = new InOutResultOrderEo();
        updateEo.setId(inOutResultOrderEo.getId());
        updateEo.setOrderStatus(this.getCompleteStatus());
        updateEo.setTotalQuantity((BigDecimal)Optional.ofNullable(inOutResultOrderContext.getOrderBasicsDetailReqDtoList()).filter(CollectionUtils::isNotEmpty).map(list -> list.stream().map(BaseOrderDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(null));
        updateEo.setTotalVolume(inOutResultOrderEo.getTotalVolume());
        updateEo.setTotalWeight(inOutResultOrderEo.getTotalWeight());
        updateEo.setRemark(inOutResultOrderContext.getRemark());
        this.inOutResultOrderDomain.getMapper().updateById((BaseEo)updateEo);
        this.unhookAfter(inOutResultOrderContext);
    }

    protected abstract void setUnhookWarehouse(InOutResultOrderContext var1);

    protected abstract void unhookAfter(InOutResultOrderContext var1);

    public CalcDetailDto getCalcDetailDto(InOutResultOrderContext context, InOutResultOrderDetailEo detail) {
        CalcDetailDto detailDto = new CalcDetailDto();
        detailDto.setBatch(detail.getBatch());
        detailDto.setExpireDate(detail.getExpireTime());
        detailDto.setLineNo(detail.getLineNo());
        detailDto.setLogicWarehouseCode(context.getLogicWarehouseCode());
        detailDto.setProduceDate(detail.getProduceTime());
        detailDto.setSkuCode(detail.getSkuCode());
        detailDto.setNum(detail.getDoneQuantity());
        return detailDto;
    }

    @Override
    public boolean validCancel(InOutResultOrderContext context) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"document_no", (Object)context.getDocumentNo());
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutResultOrderEo inOutResultOrderEo = (InOutResultOrderEo)this.inOutResultOrderDomain.getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtil.isTrue((null != inOutResultOrderEo ? 1 : 0) != 0, (String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u4fe1\u606f");
        context.setInOutResultOrderEo(inOutResultOrderEo);
        context.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)inOutResultOrderEo.getRelevanceTableName()));
        return false;
    }
}

