/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.calc.FormInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FormOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FutureInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.LockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseFutureInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseIntransitDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseLockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferOutDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.calc.IFormInAble;
import com.yunxi.dg.base.center.inventory.service.calc.IFormOutAble;
import com.yunxi.dg.base.center.inventory.service.calc.IFutureInAble;
import com.yunxi.dg.base.center.inventory.service.calc.ILockAble;
import com.yunxi.dg.base.center.inventory.service.calc.IPreemptAble;
import com.yunxi.dg.base.center.inventory.service.calc.IReleaseFutureInAble;
import com.yunxi.dg.base.center.inventory.service.calc.IReleaseIntransitAble;
import com.yunxi.dg.base.center.inventory.service.calc.IReleaseLockAble;
import com.yunxi.dg.base.center.inventory.service.calc.IReleasePreemptAble;
import com.yunxi.dg.base.center.inventory.service.calc.ITransferInAble;
import com.yunxi.dg.base.center.inventory.service.calc.ITransferOutAble;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CalcInventoryServiceImpl
implements ICalcInventoryService {
    private static final Logger log = LoggerFactory.getLogger(CalcInventoryServiceImpl.class);
    @Autowired
    IFormInAble formInAble;
    @Autowired
    IFormOutAble formOutAble;
    @Autowired
    IFutureInAble futureInAble;
    @Autowired
    IReleaseFutureInAble releaseFutureInAble;
    @Autowired
    ILockAble lockAble;
    @Autowired
    IPreemptAble preemptAble;
    @Autowired
    IReleaseLockAble releaseLockAble;
    @Autowired
    IReleasePreemptAble releasePreemptAble;
    @Autowired
    ITransferInAble transferInAble;
    @Autowired
    ITransferOutAble transferOutAble;
    @Autowired
    IReleaseIntransitAble releaseIntransitAble;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void formIn(FormInDto dto) {
        this.formInAble.formIn(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void formOut(FormOutDto dto) {
        this.formOutAble.formOut(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void futureIn(FutureInDto dto) {
        this.futureInAble.futureIn(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void releaseFutureIn(ReleaseFutureInDto dto) {
        this.releaseFutureInAble.releaseFutureIn(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void lock(LockDto dto) {
        this.lockAble.lock(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<InventoryPreemptionEo> preempt(PreemptDto dto) {
        return this.preemptAble.preempt(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<InventoryPreemptionEo> updatePreempt(PreemptDto dto) {
        return this.preemptAble.updatePreempt(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<InventoryPreemptionEo> batchPreempt(List<PreemptDto> dtoList) {
        ArrayList inventoryPreemptionEos = Lists.newArrayList();
        for (PreemptDto preemptDto : dtoList) {
            inventoryPreemptionEos.addAll(this.preemptAble.preempt(preemptDto));
        }
        return inventoryPreemptionEos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void releaseLock(ReleaseLockDto dto) {
        dto.setValidNegative(Boolean.FALSE);
        this.releaseLockAble.releaseLock(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void releasePreempt(ReleasePreemptDto dto) {
        dto.setValidNegative(Boolean.valueOf(false));
        this.releasePreemptAble.releasePreempt(dto);
    }

    @Override
    public void releaseInransit(ReleaseIntransitDto dto) {
        this.releaseIntransitAble.releaseIntransit(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void transferIn(TransferInDto dto) {
        this.transferInAble.transferIn(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void transferOut(TransferOutDto dto) {
        this.transferOutAble.transferOut(dto);
    }
}

