/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.dao.das.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.center.report.dao.das.IBillDas;
import com.yunxi.dg.base.center.report.dao.mapper.BillMapper;
import com.yunxi.dg.base.center.report.dto.entity.BillDto;
import com.yunxi.dg.base.center.report.dto.entity.UpdateBillReqDto;
import com.yunxi.dg.base.center.report.dto.entity.UpdateSortingBillReqDto;
import com.yunxi.dg.base.center.report.eo.BillEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.AbstractDas;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class BillDasImpl
extends AbstractDas<BillEo, Long>
implements IBillDas {
    private static final Logger log = LoggerFactory.getLogger(BillDasImpl.class);
    @Resource
    private BillMapper mapper;

    public BillMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void updateBill(UpdateSortingBillReqDto dto) {
        List<BillEo> eoList;
        log.info("\u66f4\u65b0\u8d26\u5355\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)dto.getOutWarehouseTime()), (String)"\u66f4\u65b0\u8d26\u5355\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date date = null;
        try {
            date = sdf.parse(dto.getOutWarehouseTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        UpdateBillReqDto reqDto = new UpdateBillReqDto(Integer.valueOf(year), Integer.valueOf(month), dto.getOutPhysicsWarehouseName());
        List<Long> oldIds = this.mapper.queryIds(reqDto);
        if (CollectionUtils.isNotEmpty(oldIds)) {
            this.mapper.deleteLogicByIds(oldIds);
        }
        if (CollectionUtils.isNotEmpty(eoList = this.mapper.queryBuildBillList(reqDto))) {
            this.mapper.insertBatch(eoList);
        } else {
            log.info("\u65e0\u6570\u636e\u751f\u6210");
        }
    }

    @Override
    public BillDto updateAdjust(BillDto dto) {
        log.info("\u5206\u62e3\u8d26\u5355 updateAdjust \u8c03\u6574\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        BillEo billEo = (BillEo)this.mapper.selectById(dto.getId());
        log.info("\u5206\u62e3\u8d26\u5355 updateAdjust \u5339\u914d\u5230\u8981\u4fee\u6539\u7684\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)billEo));
        if (ObjectUtils.isNotEmpty((Object)billEo) && Objects.equals(2L, dto.getAdjustType()) && Optional.ofNullable(billEo.getSortingNum()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(dto.getAdjustNum()).orElse(BigDecimal.ZERO)) < 0) {
            throw new BizException("\u51cf\u5c11\u8d39\u7528\u8d39\u4e0d\u80fd\u5927\u4e8e\u5408\u8ba1\u5206\u62e3\u8d39");
        }
        return dto;
    }
}

