/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dao.das.IDailyDeliveryReportDas;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryReportDomain;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryReportEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DailyDeliveryReportDomainImpl
extends BaseDomainImpl<DailyDeliveryReportEo>
implements IDailyDeliveryReportDomain {
    private static final Logger log = LoggerFactory.getLogger(DailyDeliveryReportDomainImpl.class);
    @Resource
    private IDailyDeliveryReportDas das;

    public ICommonDas<DailyDeliveryReportEo> commonDas() {
        return this.das;
    }

    @Override
    public List<Long> batchDeleteByWmsOrderNoList(List<String> wmsOrderNos) {
        if (CollectionUtils.isEmpty(wmsOrderNos)) {
            return null;
        }
        List<Long> ids = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.das.filter().in((Object)"wms_order_no", wmsOrderNos)).list()).orElse(new ArrayList())).stream().map(e -> e.getId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            this.das.logicDeleteByIds(ids);
        }
        return ids;
    }

    @Override
    public List<Long> batchDeleteByOrderIdUnieList(List<String> orderIdUnies) {
        if (CollectionUtils.isEmpty(orderIdUnies)) {
            return null;
        }
        List<Long> ids = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.das.filter().in((Object)"order_id_unie", orderIdUnies)).list()).orElse(new ArrayList())).stream().map(DailyDeliveryReportEo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            this.das.logicDeleteByIds(ids);
        }
        return ids;
    }

    @Override
    public void batchDeleteByResultDocumentList(List<String> resultDocumentList) {
        if (CollectionUtils.isEmpty(resultDocumentList)) {
            return;
        }
        List ids = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.das.filter().in((Object)"out_result_no", resultDocumentList)).list()).orElse(new ArrayList())).stream().map(e -> e.getId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            this.das.logicDeleteByIds(ids);
        }
    }

    @Override
    public Map<String, DailyDeliveryReportEo> queryAddressByResultDocumentList(List<String> resultDocumentList) {
        if (CollectionUtils.isEmpty(resultDocumentList)) {
            return new HashMap<String, DailyDeliveryReportEo>();
        }
        log.info("\u6839\u636e\u51fa\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u96c6\u5408\u67e5\u8be2\u5730\u5740\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(resultDocumentList));
        return ((List)Optional.ofNullable(this.das.queryAddressByResultDocumentList(resultDocumentList)).orElse(new ArrayList())).stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getOutResultNo())).collect(Collectors.toMap(DailyDeliveryReportEo::getOutResultNo, Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public Map<String, DailyDeliveryReportEo> queryAddressByResultDocumentListByTransfer(List<String> resultDocumentList) {
        if (CollectionUtils.isEmpty(resultDocumentList)) {
            return new HashMap<String, DailyDeliveryReportEo>();
        }
        log.info("\u6839\u636e\u51fa\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u96c6\u5408\u67e5\u8be2\u5730\u5740\u4fe1\u606f\uff0c\u8c03\u62e8\u5355\uff1a{}", (Object)JSON.toJSONString(resultDocumentList));
        return ((List)Optional.ofNullable(this.das.queryAddressByResultDocumentListByTransfer(resultDocumentList)).orElse(new ArrayList())).stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getOutResultNo())).collect(Collectors.toMap(DailyDeliveryReportEo::getOutResultNo, Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public Map<String, DailyDeliveryReportEo> queryVehicleNumberByResultDocumentNoList(List<String> resultDocumentList) {
        if (CollectionUtils.isEmpty(resultDocumentList)) {
            return new HashMap<String, DailyDeliveryReportEo>();
        }
        return ((List)Optional.ofNullable(this.das.queryVehicleNumberByResultDocumentNoList(resultDocumentList)).orElse(new ArrayList())).stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getOutResultNo())).collect(Collectors.toMap(DailyDeliveryReportEo::getOutResultNo, Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public PageInfo<DailyDeliveryReportDto> queryExcludeMergeOrder(DailyDeliveryReportDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(this.das.queryExcludeMergeOrder(dto));
    }

    @Override
    public PageInfo<DailyDeliveryReportDto> queryLogisticsCostCharge(DailyDeliveryReportDto dto) {
        log.info("\u67e5\u8be2\u7269\u6d41\u8d39\u7528\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(this.das.queryLogisticsCostCharge(dto));
    }

    @Override
    public PageInfo<DailyDeliveryReportDto> queryMainOrder(DailyDeliveryReportDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(this.das.queryMainOrder(dto));
    }

    @Override
    public DailyDeliveryReportDto queryChildOrders(String wmsMergeDocumentNo) {
        return this.das.queryChildOrders(wmsMergeDocumentNo);
    }
}

