/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.scheduler.job;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="dailyDeliveryReportJob")
@Scope(value="prototype")
public class DailyDeliveryReportJob
extends SingleTupleScheduleEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DailyDeliveryReportJob.class);
    @Resource
    private IDailyDeliveryReportService dailyDeliveryReportService;

    public void before(TaskMsg taskMsg) {
        LOGGER.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u751f\u6210\u6570\u636e\u8c03\u5ea6\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        try {
            Date earlyLastMonth = DateUtil.addMonths((Date)DateUtil.getMonthBegin(), (int)-1);
            String earlyLastMonthStr = DateUtil.getDateFormat((Date)earlyLastMonth, (String)"yyyy-MM");
            this.dailyDeliveryReportService.synchronousMonthDataByDate(earlyLastMonthStr);
        }
        catch (Exception e) {
            LOGGER.error("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u751f\u6210\u6570\u636e\u8c03\u5ea6\u5f02\u5e38" + e.getMessage());
            e.printStackTrace();
            LOGGER.error(e.getMessage(), (Throwable)e);
            return true;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        LOGGER.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u751f\u6210\u6570\u636e\u8c03\u5ea6\u7ed3\u675f");
    }
}

