/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.report.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dao.mapper.SaleCountReportMapper;
import com.yunxi.dg.base.center.report.dao.mapper.SaleOrderDetailMapper;
import com.yunxi.dg.base.center.report.dto.constants.SaleCycleTypeEnum;
import com.yunxi.dg.base.center.report.dto.report.PeriodTime;
import com.yunxi.dg.base.center.report.dto.report.SaleCountReportCollection;
import com.yunxi.dg.base.center.report.dto.report.SaleCountReportDto;
import com.yunxi.dg.base.center.report.dto.report.SaleCountReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.report.SaleCountTotalItemDto;
import com.yunxi.dg.base.center.report.dto.report.SaleCountTotalQueryDto;
import com.yunxi.dg.base.center.report.dto.report.SaleCountTotalQueryReqDto;
import com.yunxi.dg.base.center.report.dto.report.SaleCountTotalRespDto;
import com.yunxi.dg.base.center.report.dto.report.SaleOrderDetailQueryReqDto;
import com.yunxi.dg.base.center.report.dto.report.SaleOrderDetailRespDto;
import com.yunxi.dg.base.center.report.dto.report.SaleOutNumDetailReqDto;
import com.yunxi.dg.base.center.report.dto.report.SaleOutNumDetailRespDto;
import com.yunxi.dg.base.center.report.dto.report.SaleOutNumTotalRespDto;
import com.yunxi.dg.base.center.report.eo.SaleCountReportEo;
import com.yunxi.dg.base.center.report.service.report.ISaleCountReportQueryService;
import com.yunxi.dg.base.center.report.util.TimeConversionUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleCountReportQueryServiceImpl
implements ISaleCountReportQueryService {
    private static final Logger log = LoggerFactory.getLogger(SaleCountReportQueryServiceImpl.class);
    @Resource
    private SaleCountReportMapper saleCountReportMapper;
    private static final String startLastTime = " 00:00:00";
    private static final String endLastTime = " 23:59:59";
    @Resource
    private SaleOrderDetailMapper saleOrderDetailMapper;

    @Override
    public RestResponse<List<SaleCountReportCollection>> querySaleNum(SaleCountReportPageReqDto dto) {
        List periodTimes = dto.getPeriodTimes();
        ArrayList<SaleCountReportCollection> respList = new ArrayList<SaleCountReportCollection>();
        if (CollectionUtils.isNotEmpty((Collection)periodTimes)) {
            Integer num = 1;
            for (PeriodTime periodTime : periodTimes) {
                SaleCountReportCollection saleCountReportCollection = new SaleCountReportCollection();
                dto.setStartTime(periodTime.getStartTime());
                dto.setEndTime(periodTime.getEndTime());
                QueryWrapper<SaleCountReportEo> filter = this.getQueryCondition(dto);
                List saleCountReportEos = this.saleCountReportMapper.selectList(filter);
                ArrayList reportDtos = new ArrayList();
                CubeBeanUtils.copyCollection((Collection)saleCountReportEos, reportDtos, SaleCountReportDto.class);
                saleCountReportCollection.setRemark(num);
                saleCountReportCollection.setSaleCountReportDtos(reportDtos);
                respList.add(saleCountReportCollection);
            }
        } else {
            QueryWrapper<SaleCountReportEo> filter = this.getQueryCondition(dto);
            List saleCountReportEos = this.saleCountReportMapper.selectList(filter);
            ArrayList dtos = new ArrayList();
            CubeBeanUtils.copyCollection(dtos, (Collection)saleCountReportEos, SaleCountReportDto.class);
            SaleCountReportCollection saleCountReportCollection = new SaleCountReportCollection();
            saleCountReportCollection.setRemark(Integer.valueOf(1));
            saleCountReportCollection.setSaleCountReportDtos(dtos);
        }
        return new RestResponse(respList);
    }

    @NotNull
    private QueryWrapper<SaleCountReportEo> getQueryCondition(SaleCountReportPageReqDto dto) {
        QueryWrapper filter = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)dto.getSalesOrganizationCode())) {
            filter.eq((Object)"sales_organization_code", (Object)dto.getSalesOrganizationCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getDepartmentCode())) {
            filter.eq((Object)"department_code", (Object)dto.getDepartmentCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getZoneCode())) {
            filter.eq((Object)"zone_code", (Object)dto.getZoneCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getStartTime()) && StringUtils.isNotEmpty((CharSequence)dto.getEndTime())) {
            filter.between((Object)"create_time", (Object)dto.getStartTime(), (Object)dto.getEndTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getCargoCode())) {
            filter.eq((Object)"cargo_code", (Object)dto.getCargoCode());
        }
        if (null != dto.getSalesOrganizationId()) {
            filter.eq((Object)"sales_organization_id", (Object)dto.getSalesOrganizationId());
        }
        return filter;
    }

    @Override
    public RestResponse<List<SaleCountTotalRespDto>> querySaleTotalNum(SaleCountTotalQueryReqDto dto) {
        log.info("\u67e5\u8be2sku\u9500\u552e\u91cf\u5165\u53c2={}", JSON.toJSON((Object)dto));
        Assert.notEmpty((Collection)dto.getItemDtoList(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getCycleType(), (String)"\u5468\u671f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getSupplyCycle(), (String)"\u5468\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        SaleCycleTypeEnum saleCycleTypeEnum = SaleCycleTypeEnum.enumOf((Integer)dto.getCycleType());
        Assert.notNull((Object)saleCycleTypeEnum, (String)"\u5468\u671f\u7c7b\u578b\u4e0d\u6b63\u786e");
        String[] supplyArry = dto.getSupplyCycle().split("-");
        String year = supplyArry[0];
        String cycle = supplyArry[1];
        String n1StartTime = "";
        String n1EndTime = "";
        String n2StartTime = "";
        String n2EndTime = "";
        String n3StartTime = "";
        String n3EndTime = "";
        Integer yearInt = Integer.valueOf(year);
        Integer cycleInt = Integer.valueOf(cycle);
        switch (saleCycleTypeEnum) {
            case QUARTER: {
                String quarterStartStr = "";
                if (Objects.equals(cycleInt, 1)) {
                    quarterStartStr = year + "-01-01";
                } else if (Objects.equals(cycleInt, 2)) {
                    quarterStartStr = year + "-04-01";
                } else if (Objects.equals(cycleInt, 3)) {
                    quarterStartStr = year + "-07-01";
                } else if (Objects.equals(cycleInt, 4)) {
                    quarterStartStr = year + "-10-01";
                }
                n1StartTime = TimeConversionUtil.getStartQuarterStr(quarterStartStr, 1);
                n1EndTime = TimeConversionUtil.getLastQuarterStr(quarterStartStr, 1);
                n2StartTime = TimeConversionUtil.getStartQuarterStr(quarterStartStr, 2);
                n2EndTime = TimeConversionUtil.getLastQuarterStr(quarterStartStr, 2);
                n3StartTime = TimeConversionUtil.getStartQuarterStr(quarterStartStr, 3);
                n3EndTime = TimeConversionUtil.getLastQuarterStr(quarterStartStr, 3);
                break;
            }
            case MONTH: {
                String monthStr = year + "-" + cycle + "-01";
                n1StartTime = TimeConversionUtil.getStartMonthStr(monthStr, 1) + startLastTime;
                n1EndTime = TimeConversionUtil.getEndMonthStr(n1StartTime) + endLastTime;
                n2StartTime = TimeConversionUtil.getStartMonthStr(monthStr, 2) + startLastTime;
                n2EndTime = TimeConversionUtil.getEndMonthStr(n2StartTime) + endLastTime;
                n3StartTime = TimeConversionUtil.getStartMonthStr(monthStr, 3) + startLastTime;
                n3EndTime = TimeConversionUtil.getEndMonthStr(n3StartTime) + endLastTime;
                break;
            }
            case WEEKS: {
                n1StartTime = TimeConversionUtil.getWeekRangeStart(yearInt, cycleInt - 1) + startLastTime;
                n1EndTime = TimeConversionUtil.getWeekRangeStart(yearInt, cycleInt - 1) + endLastTime;
                n2StartTime = TimeConversionUtil.getWeekRangeStart(yearInt, cycleInt - 2) + startLastTime;
                n2EndTime = TimeConversionUtil.getWeekRangeStart(yearInt, cycleInt - 2) + endLastTime;
                n3StartTime = TimeConversionUtil.getWeekRangeStart(yearInt, cycleInt - 3) + startLastTime;
                n3EndTime = TimeConversionUtil.getWeekRangeStart(yearInt, cycleInt - 3) + endLastTime;
                break;
            }
            case DAY: {
                String initDayStr = year + "-01-01";
                Date initDayTime = DateUtil.parseDate((String)initDayStr, (String)"yyyy-MM-dd");
                Date cycleDayTime = DateUtil.addDays((Date)initDayTime, (int)cycleInt);
                Date n1DayTime = DateUtil.addDays((Date)cycleDayTime, (int)-1);
                n1StartTime = DateUtil.getDateFormat((Date)n1DayTime, (String)"yyyy-MM-dd") + startLastTime;
                n1EndTime = DateUtil.getDateFormat((Date)n1DayTime, (String)"yyyy-MM-dd") + endLastTime;
                Date n2DayTime = DateUtil.addDays((Date)cycleDayTime, (int)-2);
                n2StartTime = DateUtil.getDateFormat((Date)n2DayTime, (String)"yyyy-MM-dd") + startLastTime;
                n2EndTime = DateUtil.getDateFormat((Date)n2DayTime, (String)"yyyy-MM-dd") + endLastTime;
                Date n3DayTime = DateUtil.addDays((Date)cycleDayTime, (int)-3);
                n3StartTime = DateUtil.getDateFormat((Date)n3DayTime, (String)"yyyy-MM-dd") + startLastTime;
                n3EndTime = DateUtil.getDateFormat((Date)n3DayTime, (String)"yyyy-MM-dd") + endLastTime;
                break;
            }
        }
        SaleCountTotalQueryDto saleCountTotalQueryDto = new SaleCountTotalQueryDto();
        saleCountTotalQueryDto.setCycleType(dto.getCycleType());
        saleCountTotalQueryDto.setSupplyCycle(dto.getSupplyCycle());
        saleCountTotalQueryDto.setZoneCode(dto.getZoneCode());
        Set orgSet = dto.getItemDtoList().stream().map(SaleCountTotalItemDto::getOrganizationCode).collect(Collectors.toSet());
        saleCountTotalQueryDto.setOrganizationCodeList(new ArrayList(orgSet));
        Set skuCodeSet = dto.getItemDtoList().stream().map(SaleCountTotalItemDto::getSkuCode).collect(Collectors.toSet());
        saleCountTotalQueryDto.setSkuCodeList(new ArrayList(skuCodeSet));
        Set physicsWarehouseCodeSet = dto.getItemDtoList().stream().map(SaleCountTotalItemDto::getPhysicsWarehouseCode).collect(Collectors.toSet());
        saleCountTotalQueryDto.setPhysicsWarehouseCodeList(new ArrayList(physicsWarehouseCodeSet));
        saleCountTotalQueryDto.setStartTime1(n1StartTime);
        saleCountTotalQueryDto.setEndTime1(n1EndTime);
        saleCountTotalQueryDto.setStartTime2(n2StartTime);
        saleCountTotalQueryDto.setEndTime2(n2EndTime);
        saleCountTotalQueryDto.setStartTime3(n3StartTime);
        saleCountTotalQueryDto.setEndTime3(n3EndTime);
        List saleCountTotalList = this.saleCountReportMapper.querySaleCountSumByTime(saleCountTotalQueryDto);
        Map<Object, Object> skuGroupMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)saleCountTotalList)) {
            skuGroupMap = saleCountTotalList.stream().collect(Collectors.toMap(e -> e.getOrganizationCode() + "_" + e.getSkuCode() + "_" + e.getPhysicsWarehouseCode(), Function.identity(), (k1, k2) -> k1));
        }
        ArrayList respDtoList = Lists.newArrayList();
        for (SaleCountTotalItemDto saleCountTotalItemDto : dto.getItemDtoList()) {
            SaleCountTotalRespDto resultDto = new SaleCountTotalRespDto();
            resultDto.setSkuCode(saleCountTotalItemDto.getSkuCode());
            resultDto.setOrganizationCode(saleCountTotalItemDto.getOrganizationCode());
            resultDto.setPhysicsWarehouseCode(saleCountTotalItemDto.getPhysicsWarehouseCode());
            resultDto.setAvg3plan(BigDecimal.ZERO);
            resultDto.setN1plan(BigDecimal.ZERO);
            resultDto.setN2plan(BigDecimal.ZERO);
            resultDto.setN3plan(BigDecimal.ZERO);
            String key = saleCountTotalItemDto.getOrganizationCode() + "_" + saleCountTotalItemDto.getSkuCode() + "_" + saleCountTotalItemDto.getPhysicsWarehouseCode();
            if (skuGroupMap.containsKey(key)) {
                SaleCountTotalRespDto totalRespDto = (SaleCountTotalRespDto)skuGroupMap.get(key);
                CubeBeanUtils.copyProperties((Object)resultDto, (Object)totalRespDto, (String[])new String[0]);
            }
            respDtoList.add(resultDto);
        }
        return new RestResponse((Object)respDtoList);
    }

    @Override
    public RestResponse<List<SaleOutNumTotalRespDto>> querySaleOutNumTotal(SaleCountTotalQueryReqDto dto) {
        log.info("\u67e5\u8be2\u9500\u552e\u5355\u51fa\u5e93\u7ed3\u679c\u5355\u51fa\u5e93\u5355\u91cf\u5165\u53c2={}", JSON.toJSON((Object)dto));
        SaleCountTotalQueryDto saleCountTotalQueryDto = new SaleCountTotalQueryDto();
        String supplyCycle = dto.getSupplyCycle();
        Date date = DateUtil.parseDate((String)(supplyCycle + "-01"), (String)"yyyy-MM-dd");
        saleCountTotalQueryDto.setStartTime(DateUtil.getDateFormat((Date)DateUtil.getMonthBegin((Date)date), (String)"yyyy-MM-dd HH:mm:ss"));
        saleCountTotalQueryDto.setEndTime(DateUtil.getDateFormat((Date)DateUtil.getMonthEnd((Date)date), (String)"yyyy-MM-dd HH:mm:ss"));
        Set orgSet = dto.getItemDtoList().stream().map(SaleCountTotalItemDto::getOrganizationCode).collect(Collectors.toSet());
        saleCountTotalQueryDto.setOrganizationCodeList(new ArrayList(orgSet));
        Set skuCodeSet = dto.getItemDtoList().stream().map(SaleCountTotalItemDto::getSkuCode).collect(Collectors.toSet());
        saleCountTotalQueryDto.setSkuCodeList(new ArrayList(skuCodeSet));
        saleCountTotalQueryDto.setTotalType(Integer.valueOf(1));
        List saleSplitNumTotalRespDtos = this.saleCountReportMapper.querySaleDeliveryNumTotal(saleCountTotalQueryDto);
        Map<Object, Object> splitNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)saleSplitNumTotalRespDtos)) {
            splitNumMap = saleSplitNumTotalRespDtos.stream().collect(Collectors.toMap(o -> o.getOrganizationCode() + "_" + o.getPhysicsWarehouseCode() + "_" + o.getSkuCode(), Function.identity(), (k1, k2) -> k1));
        }
        saleCountTotalQueryDto.setTotalType(Integer.valueOf(2));
        List saleTargetNumTotalRespDtos = this.saleCountReportMapper.querySaleDeliveryNumTotal(saleCountTotalQueryDto);
        Map<Object, Object> targetNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)saleTargetNumTotalRespDtos)) {
            targetNumMap = saleTargetNumTotalRespDtos.stream().collect(Collectors.toMap(o -> o.getOrganizationCode() + "_" + o.getPhysicsWarehouseCode() + "_" + o.getSkuCode(), Function.identity(), (k1, k2) -> k1));
        }
        ArrayList resultList = Lists.newArrayList();
        List itemDtoList = dto.getItemDtoList();
        for (SaleCountTotalItemDto saleCountTotalItemDto : itemDtoList) {
            BigDecimal deliveryNum;
            String key = saleCountTotalItemDto.getOrganizationCode() + "_" + saleCountTotalItemDto.getPhysicsWarehouseCode() + "_" + saleCountTotalItemDto.getSkuCode();
            SaleOutNumTotalRespDto result = new SaleOutNumTotalRespDto();
            result.setSkuCode(saleCountTotalItemDto.getSkuCode());
            result.setPhysicsWarehouseCode(saleCountTotalItemDto.getPhysicsWarehouseCode());
            result.setOrganizationCode(saleCountTotalItemDto.getOrganizationCode());
            result.setSplitDeliveryNum(BigDecimal.ZERO);
            result.setTargetDeliveryNum(BigDecimal.ZERO);
            if (splitNumMap.containsKey(key)) {
                deliveryNum = ((SaleOutNumTotalRespDto)splitNumMap.get(key)).getDeliveryNum();
                result.setSplitDeliveryNum(deliveryNum);
            }
            if (targetNumMap.containsKey(key)) {
                deliveryNum = ((SaleOutNumTotalRespDto)targetNumMap.get(key)).getDeliveryNum();
                result.setTargetDeliveryNum(deliveryNum);
            }
            resultList.add(result);
        }
        return new RestResponse((Object)resultList);
    }

    @Override
    public RestResponse<PageInfo<SaleOutNumDetailRespDto>> querySaleOutNumDetailPage(SaleOutNumDetailReqDto dto) {
        AssertUtils.notEmpty((String)dto.getSupplyCycle(), (String)"\u5468\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        SaleCountTotalQueryDto saleCountTotalQueryDto = new SaleCountTotalQueryDto();
        String supplyCycle = dto.getSupplyCycle();
        Date date = DateUtil.parseDate((String)(supplyCycle + "-01"), (String)"yyyy-MM-dd");
        saleCountTotalQueryDto.setStartTime(DateUtil.getDateFormat((Date)DateUtil.getMonthBegin((Date)date), (String)"yyyy-MM-dd HH:mm:ss"));
        saleCountTotalQueryDto.setEndTime(DateUtil.getDateFormat((Date)DateUtil.getMonthEnd((Date)date), (String)"yyyy-MM-dd HH:mm:ss"));
        saleCountTotalQueryDto.setTotalType(dto.getTotalType());
        saleCountTotalQueryDto.setOrganizationCodeList(Collections.singletonList(dto.getOrganizationCode()));
        saleCountTotalQueryDto.setSkuCodeList(Collections.singletonList(dto.getSkuCode()));
        saleCountTotalQueryDto.setPhysicsWarehouseCodeList(Collections.singletonList(dto.getPhysicsWarehouseCode()));
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List saleOutNumDetailRespDtos = this.saleCountReportMapper.querySaleDeliveryNumPage(saleCountTotalQueryDto);
        return new RestResponse((Object)new PageInfo(saleOutNumDetailRespDtos));
    }

    @Override
    public RestResponse<List<SaleOrderDetailRespDto>> querySaleOrderDetail(SaleOrderDetailQueryReqDto dto) {
        log.info("\u9500\u552e\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570:{}", JSONArray.toJSON((Object)dto));
        AssertUtils.notEmpty((String)dto.getPlatformOrderNo(), (String)"\u6e20\u9053\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List result = this.saleOrderDetailMapper.querySaleOrderDetail(dto);
        return new RestResponse((Object)result);
    }
}

