/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.dao.das.impl;

import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.WarehouseRelationReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.WarehouseRelationRespDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.dao.das.IChannelInventoryDas;
import com.yunxi.dg.base.center.share.dao.mapper.ChannelInventoryMapper;
import com.yunxi.dg.base.center.share.dto.InventoryQueryReqDto;
import com.yunxi.dg.base.center.share.dto.InventorySummaryRespDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcUpdateInventoryDto;
import com.yunxi.dg.base.center.share.eo.ChannelInventoryEo;
import com.yunxi.dg.base.center.share.exception.WarehouseAbleException;
import com.yunxi.dg.base.framework.core.db.das.AbstractDas;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class ChannelInventoryDasImpl
extends AbstractDas<ChannelInventoryEo, Long>
implements IChannelInventoryDas {
    private static final Logger log = LoggerFactory.getLogger(ChannelInventoryDasImpl.class);
    @Resource
    private ChannelInventoryMapper mapper;

    public ChannelInventoryMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void updateInventory(List<CalcUpdateInventoryDto> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            throw new CsInventoryException("\u6e20\u9053\u4ed3\u6279\u91cf\u66f4\u65b0\uff1a\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        try {
            this.mapper.updateInventory(voList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("channel updateInventory exception...");
            throw new WarehouseAbleException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...", new Object[0]);
        }
    }

    @Override
    public int batchInsertInventory(List<ChannelInventoryEo> eoList) {
        return this.mapper.batchInsertInventory(eoList);
    }

    @Override
    public InventorySummaryRespDto querySummary(InventoryQueryReqDto reqDto) {
        return this.mapper.querySummary(reqDto);
    }

    @Override
    public void updateSkuNameBySkuCode(String skuCode, String skuName) {
        this.mapper.updateSkuNameBySkuCode(skuCode, skuName);
    }

    @Override
    public PageInfo<WarehouseRelationRespDto> queryWarehouseRelation(WarehouseRelationReqDto queryDto) {
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        if (null == pageNum) {
            pageNum = 1;
        }
        if (null == pageSize) {
            pageSize = 10;
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return new PageInfo(this.mapper.queryWarehouseRelation(queryDto));
    }
}

