/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.service.calc.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDto;
import com.yunxi.dg.base.center.share.enums.WarehouseClassifyEnum;
import com.yunxi.dg.base.center.share.eo.ChannelInventoryEo;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import com.yunxi.dg.base.center.share.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.service.calc.IUpdatePreemptAble;
import com.yunxi.dg.base.center.share.service.calc.impl.PreemptAble;
import com.yunxi.dg.base.center.share.service.calc.impl.ReleasePreemptAble;
import com.yunxi.dg.base.center.share.service.calc.impl.WarehouseCommonAble;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdatePreemptAble
extends WarehouseCommonAble
implements IUpdatePreemptAble {
    private static final Logger log = LoggerFactory.getLogger(UpdatePreemptAble.class);
    @Autowired
    PreemptAble preemptAble;
    @Autowired
    ReleasePreemptAble releasePreemptAble;

    @Override
    public void updatePreempt(List<ReleasePreemptDto> releasePreemptDtoList, List<PreemptDto> preemptDtoList) {
        log.info("ShUpdatePreemptAble updatePreempt releasePreemptDtoList: {}, preemptDtoList:{}", (Object)LogUtils.buildLogContent(releasePreemptDtoList), (Object)LogUtils.buildLogContent(preemptDtoList));
        HashSet allCargoCodes = Sets.newHashSet();
        HashSet allChannelWarehouseCodes = Sets.newHashSet();
        HashSet allVirtualWarehouseCodes = Sets.newHashSet();
        List<Object> releasePreemptionEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(releasePreemptDtoList)) {
            List<String> sourceNos = releasePreemptDtoList.stream().map(OperationDto::getSourceNo).distinct().collect(Collectors.toList());
            releasePreemptionEos = this.queryPreemptEos(sourceNos, null);
        }
        List releaseCargoCodes = releasePreemptionEos.stream().map(InventoryPreemptionEo::getSkuCode).distinct().collect(Collectors.toList());
        Map<String, List<InventoryPreemptionEo>> releasePreemptClassifyMap = releasePreemptionEos.stream().collect(Collectors.groupingBy(InventoryPreemptionEo::getWarehouseClassify));
        List<InventoryPreemptionEo> channelPreemptionEos = releasePreemptClassifyMap.getOrDefault(WarehouseClassifyEnum.CHANNEL.getCode(), Lists.newArrayList());
        List<InventoryPreemptionEo> virtualPreemptionEos = releasePreemptClassifyMap.getOrDefault(WarehouseClassifyEnum.VIRTUAL.getCode(), Lists.newArrayList());
        List releaseChannelWarehouseCodes = channelPreemptionEos.stream().map(InventoryPreemptionEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List releaseVirtualWarehouseCodes = virtualPreemptionEos.stream().map(InventoryPreemptionEo::getWarehouseCode).distinct().collect(Collectors.toList());
        allCargoCodes.addAll(releaseCargoCodes);
        allChannelWarehouseCodes.addAll(releaseChannelWarehouseCodes);
        allVirtualWarehouseCodes.addAll(releaseVirtualWarehouseCodes);
        Map<Object, Object> preemptChannelToVirtualMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(preemptDtoList)) {
            ArrayList allPreemptChannelWarehouseCodes = Lists.newArrayList();
            for (PreemptDto preemptDto : preemptDtoList) {
                List list = preemptDto.getDetails().stream().map(OperationDetailDto::getWarehouseCode).distinct().collect(Collectors.toList());
                List preemptCargoCodes = preemptDto.getDetails().stream().map(OperationDetailDto::getSkuCode).distinct().collect(Collectors.toList());
                allPreemptChannelWarehouseCodes.addAll(list);
                allCargoCodes.addAll(preemptCargoCodes);
            }
            preemptChannelToVirtualMap = this.queryVirtualWarehouseByChannelWarehouseCodes(allPreemptChannelWarehouseCodes);
            ArrayList preemptVirtualWarehouseCodes = Lists.newArrayList();
            for (Map.Entry<Object, Object> entry : preemptChannelToVirtualMap.entrySet()) {
                preemptVirtualWarehouseCodes.addAll(((List)entry.getValue()).stream().map(VirtualWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList()));
                allVirtualWarehouseCodes.addAll(preemptVirtualWarehouseCodes);
            }
            allChannelWarehouseCodes.addAll(allPreemptChannelWarehouseCodes);
        }
        List<ItemSkuDto> allItemSkuDtoList = this.queryItemSkuListByCodes(Lists.newArrayList((Iterable)allCargoCodes));
        Map<String, List<ChannelWarehouseEo>> allVirtualToChannelMap = this.queryChannelWarehouseByVirtualWarehouseCodes(Lists.newArrayList((Iterable)allVirtualWarehouseCodes));
        List<ChannelWarehouseEo> list = this.queryChannelWarehouseByCode(Lists.newArrayList((Iterable)allChannelWarehouseCodes));
        for (Map.Entry<String, List<ChannelWarehouseEo>> entry : allVirtualToChannelMap.entrySet()) {
            list.addAll((Collection<ChannelWarehouseEo>)entry.getValue());
        }
        List<ChannelWarehouseEo> list2 = list.stream().distinct().collect(Collectors.toList());
        List<VirtualWarehouseEo> list3 = this.queryVirtualWarehouseByCodes(Lists.newArrayList((Iterable)allVirtualWarehouseCodes));
        this.updateInventoryPreemptionValidBatch(EnableDisableEnum.DISABLE.getCode(), releasePreemptionEos);
        List<ChannelInventoryEo> allChannelInventoryEos = this.queryChannelInventoryEos(allItemSkuDtoList, list2);
        List<VirtualInventoryEo> allVirtualInventoryEos = this.queryVirtualInventoryEos(allItemSkuDtoList, list3);
        ArrayList calcChannelInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcChannelInventoryEos, allChannelInventoryEos, ChannelInventoryEo.class);
        ArrayList calcVirtualInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcVirtualInventoryEos, allVirtualInventoryEos, VirtualInventoryEo.class);
        ArrayList channelCalcInventoryDtoList = Lists.newArrayList();
        ArrayList virtualCalcInventoryDtoList = Lists.newArrayList();
        ArrayList otherChannelCalcInventoryDtoList = Lists.newArrayList();
        this.doBatchReleasePreempt(releasePreemptDtoList, channelPreemptionEos, virtualPreemptionEos, allVirtualToChannelMap, allChannelInventoryEos, allVirtualInventoryEos, channelCalcInventoryDtoList, virtualCalcInventoryDtoList, otherChannelCalcInventoryDtoList);
        this.doBatchPreempt(preemptDtoList, list2, list3, allItemSkuDtoList, allVirtualToChannelMap, preemptChannelToVirtualMap, allChannelInventoryEos, allVirtualInventoryEos, channelCalcInventoryDtoList, virtualCalcInventoryDtoList, otherChannelCalcInventoryDtoList);
        this.calcAble.calcBatchChannelAndOtherChannel(channelCalcInventoryDtoList, otherChannelCalcInventoryDtoList, calcChannelInventoryEos);
        this.calcAble.calcBatchVirtual(virtualCalcInventoryDtoList, calcVirtualInventoryEos);
    }

    private void doBatchReleasePreempt(List<ReleasePreemptDto> releasePreemptDtoList, List<InventoryPreemptionEo> channelPreemptionEos, List<InventoryPreemptionEo> virtualPreemptionEos, Map<String, List<ChannelWarehouseEo>> allVirtualToChannelMap, List<ChannelInventoryEo> allChannelInventoryEos, List<VirtualInventoryEo> allVirtualInventoryEos, List<CalcInventoryDto> channelCalcInventoryDtoList, List<CalcInventoryDto> virtualCalcInventoryDtoList, List<CalcInventoryDto> otherChannelCalcInventoryDtoList) {
        if (CollectionUtils.isEmpty(releasePreemptDtoList)) {
            return;
        }
        for (ReleasePreemptDto releasePreemptParam : releasePreemptDtoList) {
            List<InventoryPreemptionEo> channelPreemptEos = channelPreemptionEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSourceNo(), (CharSequence)releasePreemptParam.getSourceNo())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(channelPreemptEos)) continue;
            String channelWarehouseCode = ((InventoryPreemptionEo)channelPreemptEos.get(0)).getWarehouseCode();
            releasePreemptParam.setExternalOrderNo(((InventoryPreemptionEo)channelPreemptEos.get(0)).getExternalOrderNo());
            CalcInventoryDto channelCalcDto = this.releasePreemptAble.createChannelCalcDto(releasePreemptParam, channelPreemptEos);
            channelCalcInventoryDtoList.add(channelCalcDto);
            this.changeChannelInventory(channelCalcDto, allChannelInventoryEos);
            List<InventoryPreemptionEo> virtualPreemptEos = virtualPreemptionEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSourceNo(), (CharSequence)releasePreemptParam.getSourceNo())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(virtualPreemptEos)) continue;
            CalcInventoryDto virtualCalcDto = this.releasePreemptAble.createVirtualCalcDto(releasePreemptParam, virtualPreemptEos);
            virtualCalcInventoryDtoList.add(virtualCalcDto);
            this.changeVirtualInventory(virtualCalcDto, allVirtualInventoryEos);
            List virtualWarehouseCodes = virtualPreemptEos.stream().map(InventoryPreemptionEo::getWarehouseCode).distinct().collect(Collectors.toList());
            HashMap virtualToChannelMap = Maps.newHashMap();
            for (String virtualWarehouseCode : virtualWarehouseCodes) {
                List<ChannelWarehouseEo> channelWarehouseEoList = allVirtualToChannelMap.get(virtualWarehouseCode);
                virtualToChannelMap.put(virtualWarehouseCode, channelWarehouseEoList);
            }
            CalcInventoryDto otherChannelCalcDto = this.createOtherChannelCalcDto(virtualToChannelMap, virtualCalcDto, channelWarehouseCode);
            otherChannelCalcDto.setValidNegative(Boolean.valueOf(false));
            otherChannelCalcInventoryDtoList.add(otherChannelCalcDto);
            this.changeChannelInventory(otherChannelCalcDto, allChannelInventoryEos);
        }
    }

    private void doBatchPreempt(List<PreemptDto> preemptDtoList, List<ChannelWarehouseEo> allChannelWarehouseEos, List<VirtualWarehouseEo> allVirtualWarehouseEos, List<ItemSkuDto> allItemSkuDtoList, Map<String, List<ChannelWarehouseEo>> allVirtualToChannelMap, Map<String, List<VirtualWarehouseEo>> preemptChannelToVirtualMap, List<ChannelInventoryEo> allChannelInventoryEos, List<VirtualInventoryEo> allVirtualInventoryEos, List<CalcInventoryDto> channelCalcInventoryDtoList, List<CalcInventoryDto> virtualCalcInventoryDtoList, List<CalcInventoryDto> otherChannelCalcInventoryDtoList) {
        if (CollectionUtils.isEmpty(preemptDtoList)) {
            return;
        }
        List<String> sourceNos = preemptDtoList.stream().map(OperationDto::getSourceNo).distinct().collect(Collectors.toList());
        List<InventoryPreemptionEo> preemptionEos = this.queryPreemptEos(sourceNos, null);
        ArrayList insertPreemptEos = Lists.newArrayList();
        for (PreemptDto preemptDto : preemptDtoList) {
            String channelWarehouseCode = ((OperationDetailDto)preemptDto.getDetails().get(0)).getWarehouseCode();
            ChannelWarehouseEo channelWarehouseEo = this.filterChannelWarehouseByCode(allChannelWarehouseEos, channelWarehouseCode);
            if (null == channelWarehouseEo) {
                throw new BizException("09527", String.format("\u6e20\u9053\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728, \u6e20\u9053\u4ed3\u7f16\u7801: %s", channelWarehouseCode));
            }
            if (preemptDto.getValidDisableWarehouse().booleanValue() && EnableDisableEnum.DISABLE.getCode().equals(channelWarehouseEo.getWarehouseStatus())) {
                throw new BizException("09527", String.format("\u6e20\u9053\u4ed3\u5df2\u88ab\u7981\u7528\uff0c \u6e20\u9053\u4ed3\u7f16\u7801: %s", channelWarehouseCode));
            }
            List filterPreemptEos = preemptionEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSourceNo(), (CharSequence)preemptDto.getSourceNo())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(filterPreemptEos)) continue;
            List<Object> relVirtualWarehouseEos = preemptChannelToVirtualMap.get(channelWarehouseCode);
            if (preemptDto.getIsShoutVirtualWarehouse().booleanValue()) {
                AssertUtils.notBlank((String)preemptDto.getShoutVirtualWarehouseCode(), (String)"\u6307\u5b9a\u4f9b\u8d27\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                relVirtualWarehouseEos = relVirtualWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)preemptDto.getShoutVirtualWarehouseCode())).collect(Collectors.toList());
                AssertUtils.notEmpty(relVirtualWarehouseEos, (String)"\u6307\u5b9a\u4f9b\u8d27\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
            }
            CalcInventoryDto channelCalcDto = this.preemptAble.createChannelCalcDto(preemptDto);
            channelCalcInventoryDtoList.add(channelCalcDto);
            List preemptSkuCodes = preemptDto.getDetails().stream().map(OperationDetailDto::getSkuCode).distinct().collect(Collectors.toList());
            List preemptVirtualWarehouseCodes = relVirtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
            List<VirtualInventoryEo> preemptVirtualInventoryEos = allVirtualInventoryEos.stream().filter(o -> preemptSkuCodes.contains(o.getSkuCode()) && preemptVirtualWarehouseCodes.contains(o.getWarehouseCode())).distinct().collect(Collectors.toList());
            CalcInventoryDto virtualCalcDto = this.preemptAble.createVirtualCalcDto(preemptDto, preemptVirtualInventoryEos, allVirtualWarehouseEos);
            virtualCalcInventoryDtoList.add(virtualCalcDto);
            HashMap virtualToChannelMap = Maps.newHashMap();
            for (String virtualWarehouseCode : preemptVirtualWarehouseCodes) {
                List<ChannelWarehouseEo> channelWarehouseEoList = allVirtualToChannelMap.get(virtualWarehouseCode);
                virtualToChannelMap.put(virtualWarehouseCode, channelWarehouseEoList);
            }
            CalcInventoryDto otherChannelCalcDto = this.createOtherChannelCalcDto(virtualToChannelMap, virtualCalcDto, channelWarehouseCode);
            otherChannelCalcDto.setValidNegative(preemptDto.getValidNegative());
            otherChannelCalcInventoryDtoList.add(otherChannelCalcDto);
            List<ItemSkuDto> itemSkuDtoList = allItemSkuDtoList.stream().filter(o -> preemptSkuCodes.contains(o.getSkuCode())).collect(Collectors.toList());
            List<ChannelInventoryEo> channelInventoryEos = allChannelInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)channelWarehouseCode) && preemptSkuCodes.contains(o.getSkuCode())).collect(Collectors.toList());
            List<InventoryPreemptionEo> insertChannelPreemptEos = this.createChannelPreemptEos(channelCalcDto, Lists.newArrayList((Object[])new ChannelWarehouseEo[]{channelWarehouseEo}), itemSkuDtoList, channelInventoryEos);
            insertPreemptEos.addAll(insertChannelPreemptEos);
            List<InventoryPreemptionEo> insertVirtualPreemptEos = this.createVirtualPreemptEos(virtualCalcDto, relVirtualWarehouseEos, itemSkuDtoList, preemptVirtualInventoryEos);
            insertPreemptEos.addAll(insertVirtualPreemptEos);
        }
        if (CollectionUtils.isNotEmpty((Collection)insertPreemptEos)) {
            this.inventoryPreemptionDomain.insertPreemptList((List)insertPreemptEos);
        }
    }

    private void changeChannelInventory(CalcInventoryDto channelCalcDto, List<ChannelInventoryEo> allChannelInventoryEos) {
        for (CalcInventoryDetailDto detail : channelCalcDto.getDetails()) {
            ChannelInventoryEo channelInventoryEo = this.filterChannelInventory(allChannelInventoryEos, detail.getWarehouseCode(), detail.getSkuCode());
            AssertUtils.notNull((Object)channelInventoryEo, (String)"\u6e20\u9053\u4ed3\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728, \u6e20\u9053\u4ed3\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801: %s", (Object[])new Object[]{detail.getWarehouseCode(), detail.getSkuCode()});
            channelInventoryEo.setAvailable(BigDecimalUtils.add((BigDecimal)channelInventoryEo.getAvailable(), (BigDecimal)detail.getChangeAvailable()));
        }
    }

    private void changeVirtualInventory(CalcInventoryDto virtualCalcDto, List<VirtualInventoryEo> allVirtualInventoryEos) {
        for (CalcInventoryDetailDto detail : virtualCalcDto.getDetails()) {
            VirtualInventoryEo virtualInventoryEo = this.filterVirtualInventory(allVirtualInventoryEos, detail.getWarehouseCode(), detail.getSkuCode());
            AssertUtils.notNull((Object)virtualInventoryEo, (String)"\u4f9b\u8d27\u4ed3\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728, \u4f9b\u8d27\u4ed3\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801: %s", (Object[])new Object[]{detail.getWarehouseCode(), detail.getSkuCode()});
            virtualInventoryEo.setAvailable(BigDecimalUtils.add((BigDecimal)virtualInventoryEo.getAvailable(), (BigDecimal)detail.getChangeAvailable()));
        }
    }
}

