/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleGoodsItemDas;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyGoodsItemRowVo;
import com.yunxi.dg.base.center.trade.dao.vo.OrderItemAmoutVo;
import com.yunxi.dg.base.center.trade.dao.vo.SaleOrderItermChangeVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleGoodsItemDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderGoodsItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleGoodsItemEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.vo.DgPerformOrderItemChangeVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgSaleGoodsItemDomainImpl
extends BaseDomainImpl<DgSaleGoodsItemEo>
implements IDgSaleGoodsItemDomain {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDgSaleGoodsItemDas das;
    @Resource
    private IDgPerformOrderGoodsItemExtDomain dgGoodsItemModeDomain;

    public ICommonDas<DgSaleGoodsItemEo> commonDas() {
        return this.das;
    }

    @Override
    public List<Long> queryIdsForUpdateGoodsItems(ModifyGoodsItemRowVo updateGoodsItemsVo) {
        return this.das.queryIdsForUpdateGoodsItems(updateGoodsItemsVo);
    }

    @Override
    public int updateGoodsItemsByIds(ModifyGoodsItemRowVo updateGoodsItemsVo, List<Long> idListOfChange) {
        return this.das.updateGoodsItemsByIds(updateGoodsItemsVo, idListOfChange);
    }

    @Override
    public List<OrderItemAmoutVo> calculatorOrderItemAmount(List<Long> orderIdList) {
        return this.das.calculatorOrderItemAmount(orderIdList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyGoodsItemRelation(ModifyGoodsItemRowVo modifyGoodsItemRowVo) {
        this.modifyGoodsItems(modifyGoodsItemRowVo);
        this.generalRefOrderAndGoods(modifyGoodsItemRowVo.getOrderItemId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int modifyGoodsItems(ModifyGoodsItemRowVo modifyGoodsItemRowVo) {
        AssertUtils.notNull((Object)modifyGoodsItemRowVo.getQuerySaleOrderId(), (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyGoodsItemRowVo.getQueryBelongOrderItemId(), (String)"\u5f52\u5c5e\u8ba2\u5355\u5546\u54c1\u884c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyGoodsItemRowVo.getChangeNum(), (String)"\u4fee\u6539\u7684\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        this.LOGGER.info("[\u4fee\u6539\u5546\u54c1\u884c]\u4fee\u6539\u5546\u54c1\u884c\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyGoodsItemRowVo));
        LambdaQueryWrapper queryGoodsItemsWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryGoodsItemsWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleGoodsItemEo::getOrderId, (Object)modifyGoodsItemRowVo.getQuerySaleOrderId())).eq(DgSaleGoodsItemEo::getOrderItemId, (Object)modifyGoodsItemRowVo.getQueryBelongOrderItemId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{modifyGoodsItemRowVo.getQueryOriDeliveryStatus()})) {
            queryGoodsItemsWrapper.eq(DgSaleGoodsItemEo::getDeliveryStatus, (Object)modifyGoodsItemRowVo.getQueryOriDeliveryStatus());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{modifyGoodsItemRowVo.getQueryStatus()})) {
            queryGoodsItemsWrapper.eq(DgSaleGoodsItemEo::getStatus, (Object)modifyGoodsItemRowVo.getQueryStatus());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{modifyGoodsItemRowVo.getQueryRefundStatus()})) {
            queryGoodsItemsWrapper.eq(DgSaleGoodsItemEo::getDeliveryStatus, (Object)modifyGoodsItemRowVo.getQueryRefundStatus());
        }
        int fitCount = this.das.getMapper().selectCount((Wrapper)queryGoodsItemsWrapper);
        if (modifyGoodsItemRowVo.getChangeNum() > fitCount) {
            this.LOGGER.error("[\u4fee\u6539\u5546\u54c1\u884c]\u5f53\u524d\u53ef\u4fee\u6539\u7684\u5546\u54c1\u884c\u6570\u91cf\u4e0d\u6ee1\u8db3\uff0c\u53ef\u4fee\u6539\u7684\u5546\u54c1\u884c\u6570\u91cf\u4e3a\uff1a{}", (Object)fitCount);
            throw DgPcpTradeExceptionCode.FIT_GOOD_IEM_COUNT_NOT_ENOUGHT.builderException();
        }
        List idListOfChange = this.das.queryIdsForUpdateGoodsItems(modifyGoodsItemRowVo);
        if (idListOfChange.size() != modifyGoodsItemRowVo.getChangeNum().intValue()) {
            this.LOGGER.error("[\u4fee\u6539\u5546\u54c1\u884c]\u5f53\u524d\u53ef\u4fee\u6539\u7684\u5546\u54c1\u884c\u6570\u91cf\u4e0d\u6ee1\u8db3\uff0c\u53ef\u4fee\u6539\u7684\u5546\u54c1\u884c\u6570\u91cf\u4e3a\uff1a{}", (Object)idListOfChange.size());
            throw DgPcpTradeExceptionCode.FIT_GOOD_IEM_COUNT_NOT_ENOUGHT.builderException();
        }
        int affectRow = this.das.updateGoodsItemsByIds(modifyGoodsItemRowVo, idListOfChange);
        if (affectRow != modifyGoodsItemRowVo.getChangeNum()) {
            this.LOGGER.error("[\u4fee\u6539\u5546\u54c1\u884c]\u5f53\u524d\u4fee\u6539\u751f\u6548\u7684\u5546\u54c1\u884c\u6570\u4e3a\uff1a{}\uff0c \u671f\u671b\u7684\u4fee\u6539\u884c\u6570\u4e3a\uff1a{}", (Object)affectRow, (Object)modifyGoodsItemRowVo.getChangeNum());
            throw DgPcpTradeExceptionCode.MODIFY_GOOD_IEM_FAIL.builderException();
        }
        return affectRow;
    }

    @Override
    public void saveGoodsItems(SaleOrderItermChangeVo saleOrderItermChangeVo) {
        DgPerformOrderItemChangeVo vo = new DgPerformOrderItemChangeVo();
        CubeBeanUtils.copyProperties((Object)vo, (Object)saleOrderItermChangeVo, (String[])new String[0]);
        ArrayList performOrderItemRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)performOrderItemRespDtos, (Collection)saleOrderItermChangeVo.getSaleOrderItemEos(), DgPerformOrderItemRespDto.class);
        vo.setPerformOrderItemRespDtos((List)performOrderItemRespDtos);
        this.dgGoodsItemModeDomain.saveGoodsItems(vo);
    }

    @Override
    public int updateGoodsItems(ModifyGoodsItemRowVo modifyGoodsItemRowVo) {
        return this.das.updateGoodsItems(modifyGoodsItemRowVo);
    }

    private void generalRefOrderAndGoods(Long orderItemId) {
    }
}

