/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.tc.order;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.aspect.annotation.TrackLogNode;
import com.dtyunxi.cube.component.track.commons.constant.TrackLogBizDefine;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.CisSaleOrderBizModelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ArrangeWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CspUpdateEasOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ModifyLogicalWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SearchSourceReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderByBatchReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderBySourceInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderCspRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcPerformOrderOptAction;
import com.yunxi.dg.base.center.trade.handle.tc.IDgTcSaleStatemachineHandle;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@TrackLogNode(nodeBizDefine=TrackLogBizDefine.BIZ_OPERATION_LOG, nodeBizCode="SaleOrderOptAction", nodeBizParamsKeys={"saleOrderId"}, nodeBizParamsValues={"#orderId"})
@RestController
@RequestMapping(value={"/v1/sale/order/opt"})
public class TcSaleOrderOptApiRest
implements ISaleOrderOptApi {
    @Resource
    private IDgTcPerformOrderOptAction dgTcPerformOrderOptAction;
    @Resource
    private IDgTcSaleStatemachineHandle dgTcSaleStatemachineHandle;
    @Resource
    private ISaleOrderService saleOrderService;

    public RestResponse<Void> checkOrder(Long orderId) {
        return this.dgTcSaleStatemachineHandle.checkOrder(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Boolean> arrangeWarehouseForDeliver(Long orderId, List<ArrangeWarehouseReqDto> reqDtoList) {
        this.dgTcSaleStatemachineHandle.arrangeWarehouseForDeliver(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId, reqDtoList);
        return new RestResponse((Object)Boolean.TRUE);
    }

    public RestResponse<Boolean> autoArrangeWarehouse(Long orderId) {
        this.dgTcSaleStatemachineHandle.autoArrangeWarehouse(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
        return new RestResponse((Object)Boolean.TRUE);
    }

    public RestResponse<Boolean> arrangeWarehouseByAppoint(Long orderId) {
        return this.dgTcSaleStatemachineHandle.arrangeWarehouseByAppoint(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> cancelOrder(Long orderId, String cancelReason) {
        return this.dgTcSaleStatemachineHandle.cancelOrder(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId, cancelReason);
    }

    public RestResponse<Void> cancelWmsOrder(Long orderId) {
        return this.dgTcSaleStatemachineHandle.cancelWmsOrder(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId, "WMS\u53d6\u6d88\u5355\u636e");
    }

    public RestResponse<Boolean> checkEnableRest(Long orderId) {
        return this.dgTcPerformOrderOptAction.checkEnableRest(orderId);
    }

    public RestResponse<Void> modifyAddress(Long orderId, SaleOrderAddrReqDto reqDto) {
        return this.dgTcPerformOrderOptAction.modifyAddress(orderId, reqDto);
    }

    public RestResponse<Void> modifyPlanDeliveryDate(Long orderId, String newDate) {
        return this.dgTcPerformOrderOptAction.modifyPlanDeliveryDate(orderId, newDate);
    }

    public RestResponse<Void> cancelCspOrder(@PathVariable(value="platformOrderId") Long platformOrderId) {
        return this.dgTcPerformOrderOptAction.cancelCspOrder(platformOrderId);
    }

    public RestResponse<Void> resetOrder(Long orderId) {
        return this.dgTcSaleStatemachineHandle.resetOrder(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Boolean> confirmReceiptGoods(Long orderId) {
        return this.dgTcSaleStatemachineHandle.confirmReceiptGoods(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> continueDeliver(Long orderId) {
        return this.dgTcSaleStatemachineHandle.continueDeliver(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> splitOrder(Long orderId, SplitOrderReqDto reqDto) {
        return this.dgTcSaleStatemachineHandle.splitOrder(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId, reqDto);
    }

    public RestResponse<Void> splitOrderBySku(Long orderId, String splitSku) {
        return this.dgTcSaleStatemachineHandle.splitOrderBySku(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId, splitSku);
    }

    public RestResponse<Void> splitOrderByAppointBatch(Long orderId, SplitOrderByBatchReqDto reqDto) {
        return this.dgTcSaleStatemachineHandle.splitOrderByAppointBatch(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId, reqDto);
    }

    public RestResponse<Void> searchSourceForDeliver(Long orderId, SearchSourceReqDto reqDto) {
        return this.dgTcSaleStatemachineHandle.searchSourceForDeliver(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId, reqDto);
    }

    public RestResponse<Boolean> autoArrangeWarehouseBySource(@RequestParam(value="orderId") Long orderId) {
        return this.dgTcSaleStatemachineHandle.autoArrangeWarehouseBySource(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Boolean> completeArrangeWarehouseBySource(@RequestParam(value="orderId") Long orderId) {
        return this.dgTcSaleStatemachineHandle.completeArrangeWarehouseBySource(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> unlock(Long orderId) {
        return this.dgTcSaleStatemachineHandle.unlock(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> cancelAppoint(Long orderId) {
        return this.dgTcSaleStatemachineHandle.cancelAppoint(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> codeCheck(Long orderId, String operationType) {
        return this.dgTcSaleStatemachineHandle.codeCheck(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId, operationType);
    }

    public RestResponse<Void> batchConfirmReceiptGoods(List<Long> orderIdList) {
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                this.confirmReceiptGoods(orderId);
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s ";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap);
        }
        return RestResponse.VOID;
    }

    private void throwExceptoinMessage(List<Long> orderIdOfexceptionList, String message, Map<Long, String> errMessageMap) {
        List saleOrderRespDtos = this.saleOrderService.queryByOrderIds(orderIdOfexceptionList);
        StringBuilder messageBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
            for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
                messageBuilder.append(saleOrderRespDto.getSaleOrderNo()).append(errMessageMap.get(saleOrderRespDto.getId())).append("; \n");
            }
        }
        throw new BizException(PcpTradeExceptionCode.BATCH_OPT_EXCEPTION.getCode(), String.format(message, messageBuilder.toString()));
    }

    public RestResponse<SaleOrderCspRespDto> cspUpdateEasOrderNo(@RequestBody CspUpdateEasOrderReqDto updateEasOrderReqDto) {
        return this.dgTcPerformOrderOptAction.cspUpdateEasOrderNo(updateEasOrderReqDto);
    }

    public RestResponse<Void> invalidOrder(Long orderId) {
        return this.dgTcSaleStatemachineHandle.invalidOrder(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> batchInvalidOrder(@RequestBody List<Long> orderIdList) {
        for (Long orderId : orderIdList) {
            this.invalidOrder(orderId);
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateSaleOrderStringCodeResult(@RequestBody CspUpdateEasOrderReqDto updateEasOrderReqDto) {
        return this.dgTcPerformOrderOptAction.updateSaleOrderStringCodeResult(updateEasOrderReqDto);
    }

    public RestResponse<Void> invalidOrderByPlatformOrderNo(@RequestParam(value="platformOrderNo") String platformOrderNo) {
        return this.dgTcPerformOrderOptAction.invalidOrderByPlatformOrderNo(platformOrderNo);
    }

    public RestResponse<Void> splitPick(@RequestParam(value="orderId") Long orderId) {
        return this.dgTcSaleStatemachineHandle.splitPick(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> notSplitPick(@RequestParam(value="orderId") Long orderId) {
        return this.dgTcSaleStatemachineHandle.notSplitPick(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> doPcpStatusLock(@RequestParam(value="orderId") Long orderId) {
        return this.dgTcSaleStatemachineHandle.doPcpStatusLock(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> doPcpStatusUnLock(@RequestParam(value="orderId") Long orderId) {
        return this.dgTcSaleStatemachineHandle.doPcpStatusUnLock(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> updateDefaultLogic(@RequestParam(value="orderId") Long orderId) {
        return this.dgTcPerformOrderOptAction.updateDefaultLogic(orderId);
    }

    public RestResponse<Void> advancePick(@RequestParam(value="orderId") Long orderId) {
        return this.dgTcSaleStatemachineHandle.advancePick(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> doPcpStatusLockAndSystem(@RequestParam(value="saleOrderNo") String saleOrderNo) {
        return this.dgTcPerformOrderOptAction.doPcpStatusLockAndSystem(saleOrderNo);
    }

    public RestResponse<Void> doPcpStatusUnLockAndSystem(@RequestParam(value="saleOrderNo") String saleOrderNo) {
        return this.dgTcPerformOrderOptAction.doPcpStatusUnLockAndSystem(saleOrderNo);
    }

    public RestResponse<String> partSplitPick(@RequestParam(value="orderId") Long orderId, @RequestBody SplitOrderBySourceInfoReqDto reqDto) {
        return this.dgTcSaleStatemachineHandle.partSplitPick(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId, reqDto);
    }

    public RestResponse<Void> sourceDeliveryAndTransfer(@RequestParam(value="orderId") Long orderId, @RequestBody List<SplitOrderBySourceInfoReqDto> list) {
        return this.dgTcSaleStatemachineHandle.sourceDeliveryAndTransfer(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId, list);
    }

    public RestResponse<Void> updateLogicalWarehouseAndDelivery(@RequestBody ModifyLogicalWarehouseReqDto reqDto) {
        return this.dgTcPerformOrderOptAction.updateLogicalWarehouseAndDelivery(reqDto);
    }

    public RestResponse<SaleOrderRespDto> backCheck(Long orderId) {
        return this.dgTcPerformOrderOptAction.backCheck(orderId);
    }

    public RestResponse<Void> retractOrder(@RequestParam(value="orderId") Long orderId) {
        return this.dgTcSaleStatemachineHandle.retractOrder(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> maiyouCCAllotPick(Long orderId) {
        return this.dgTcSaleStatemachineHandle.maiyouCCAllotPick(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId);
    }

    public RestResponse<Void> sourceDeliveryAndTransferMaiyou(@RequestParam(value="orderId") Long orderId, @RequestBody List<SplitOrderBySourceInfoReqDto> list) {
        return this.dgTcSaleStatemachineHandle.sourceDeliveryAndTransferMaiyou(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId, list);
    }
}

