/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.strategy;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.dto.strategy.DgBusinessAuditStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgCustomerAuditStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgLabelStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgMatchStrategyResultDto;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgBusinessStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgCustomerStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgLabelStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgOrderAutoStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgStrategyRuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"-\u8868\u670d\u52a1:\u7b56\u7565\u89c4\u5219\u8868\u670d\u52a12"})
@RequestMapping(value={"/v1/dg/sale/strategy/rule"})
public class DgStrategyRuleApiController {
    @Resource
    private IDgCustomerStrategyRuleService customerStrategyRuleService;
    @Resource
    private IDgBusinessStrategyRuleService businessStrategyRuleService;
    @Resource
    private IDgLabelStrategyRuleService labelStrategyRuleService;
    @Resource
    @Qualifier(value="dgStrategyRuleServiceImpl")
    private IDgStrategyRuleService strategyRuleService;
    @Resource
    private IDgOrderAutoStrategyRuleService dgOrderAutoStrategyRuleService;

    @PostMapping(value={"/customer/add", "/order/add"})
    @ApiOperation(value="\u65b0\u589e\u7b56\u7565\u89c4\u5219\u8868", notes="\u65b0\u589e\u7b56\u7565\u89c4\u5219\u8868")
    public RestResponse<Long> addCustomerAuditStrategyRule(@RequestBody DgCustomerAuditStrategyRuleReqDto addReqDto) {
        return new RestResponse((Object)this.customerStrategyRuleService.addCustomerAuditStrategyRule(addReqDto));
    }

    @PutMapping(value={"/customer/modify", "/order/modify"})
    @ApiOperation(value="\u4fee\u6539\u7b56\u7565\u89c4\u5219\u8868", notes="\u4fee\u6539\u7b56\u7565\u89c4\u5219\u8868")
    public RestResponse<Void> modifyCustomerAuditStrategyRule(@RequestBody DgCustomerAuditStrategyRuleReqDto modifyReqDto) {
        this.customerStrategyRuleService.modifyCustomerAuditStrategyRule(modifyReqDto);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/business/add"})
    @ApiOperation(value="\u65b0\u589e\u7b56\u7565\u89c4\u5219\u8868", notes="\u65b0\u589e\u7b56\u7565\u89c4\u5219\u8868")
    public RestResponse<Long> addBusinessAuditStrategyRule(@RequestBody DgBusinessAuditStrategyRuleReqDto addReqDto) {
        return new RestResponse((Object)this.businessStrategyRuleService.addBusinessAuditStrategyRule(addReqDto));
    }

    @PutMapping(value={"/business/modify"})
    @ApiOperation(value="\u4fee\u6539\u7b56\u7565\u89c4\u5219\u8868", notes="\u4fee\u6539\u7b56\u7565\u89c4\u5219\u8868")
    public RestResponse<Void> modifyBusinessAuditStrategyRule(@RequestBody DgBusinessAuditStrategyRuleReqDto modifyReqDto) {
        this.businessStrategyRuleService.modifyBusinessAuditStrategyRule(modifyReqDto);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/label/add"})
    @ApiOperation(value="\u65b0\u589e\u7b56\u7565\u6807\u7b7e\u89c4\u5219\u8868", notes="\u65b0\u589e\u7b56\u7565\u6807\u7b7e\u89c4\u5219\u8868")
    public RestResponse<Long> addOrderLabelStrategyRule(@RequestBody DgLabelStrategyRuleReqDto addReqDto) {
        return new RestResponse((Object)this.labelStrategyRuleService.addOrderLabelStrategyRule(addReqDto));
    }

    @PutMapping(value={"/label/modify"})
    @ApiOperation(value="\u4fee\u6539\u7b56\u7565\u6807\u7b7e\u89c4\u5219\u8868", notes="\u4fee\u6539\u7b56\u7565\u6807\u7b7e\u89c4\u5219\u8868")
    public RestResponse<Void> modifyOrderLabelStrategyRule(@RequestBody DgLabelStrategyRuleReqDto modifyReqDto) {
        this.labelStrategyRuleService.modifyOrderLabelStrategyRule(modifyReqDto);
        return RestResponse.VOID;
    }

    @DeleteMapping(value={"/remove/{id}"})
    @ApiOperation(value="\u5220\u9664\u7b56\u7565\u89c4\u5219\u8868", notes="\u5220\u9664\u7b56\u7565\u89c4\u5219\u8868")
    public RestResponse<Void> removeStrategyRule(@PathVariable(value="id") Long id) {
        this.strategyRuleService.removeStrategyRule(id);
        return RestResponse.VOID;
    }

    @PutMapping(value={"/modify/{id}/{ruleStatus}"})
    @ApiOperation(value="\u542f\u7528\u7b56\u7565", notes="\u542f\u7528\u7b56\u7565,1-\u542f\u7528\uff0c0-\u7981\u7528")
    public RestResponse<Void> modifyRuleStatus(@PathVariable(value="id") Long id, @PathVariable(value="ruleStatus") Integer ruleStatus) {
        this.strategyRuleService.modifyRuleStatus(id, ruleStatus);
        return RestResponse.VOID;
    }

    @PutMapping(value={"/testRule/{orderId}/{ruleType}"})
    @ApiOperation(value="\u6d4b\u8bd5\u7b56\u7565", notes="\u6d4b\u8bd5\u7b56\u7565")
    RestResponse<DgMatchStrategyResultDto> testRule(@PathVariable(value="orderId") Long orderId, @PathVariable(value="ruleType") String ruleType) {
        return new RestResponse((Object)this.dgOrderAutoStrategyRuleService.matchOrderStrategy(orderId, DgCisStrategyOrderTypeEnum.forCode((String)ruleType)));
    }
}

