/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.enums.NextOptTypeEnum;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;

public class StrategyHelper {
    private static final String CUSTOMER = "CUSTOMER";
    private static final String BUSINESS = "BUSINESS";

    public static String getStrategyTypeByOrderStatus(String orderStatus) {
        String strategyType = null;
        if (DgOmsSaleOrderStatus.WAIT_CUSTOMER_AUDIT.getCode().equals(orderStatus)) {
            strategyType = CUSTOMER;
        } else if (DgOmsSaleOrderStatus.WAIT_BUSINESS_AUDIT.getCode().equals(orderStatus)) {
            strategyType = BUSINESS;
        }
        AssertUtils.notBlank((String)strategyType, (String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u5e94\u8be5\u6267\u884c\u7b56\u7565\u903b\u8f91");
        return strategyType;
    }

    public static String chooseNextOptTypeByStrategyType(DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        String setNextOptType = null;
        switch (dgCisStrategyOrderTypeEnum) {
            case CUSTOMER: {
                setNextOptType = NextOptTypeEnum.CUSTOMER_AUTO_AUDIT.getType();
                break;
            }
            case BUSINESS: {
                setNextOptType = NextOptTypeEnum.BUSINESS_AUTO_AUDIT.getType();
                break;
            }
            case ORDER_REVIEW: {
                setNextOptType = NextOptTypeEnum.B2B_AUTO_AUDIT.getType();
                break;
            }
            case ORDER_CONFIRM: {
                setNextOptType = NextOptTypeEnum.B2B_AUTO_CHECK.getType();
                break;
            }
            case AUTOMATIC_ALLOCATION: {
                setNextOptType = NextOptTypeEnum.B2B_AUTO_PICK.getType();
                break;
            }
            case AUTOMATIC_DELIVERY: {
                setNextOptType = NextOptTypeEnum.B2B_AUTO_APPOINT.getType();
                break;
            }
            default: {
                throw new BizException("\u672a\u914d\u7f6e\u8be5\u7c7b\u578b\u7b56\u7565\u7684\u81ea\u52a8\u6d41\u8f6c\u4e8b\u4ef6");
            }
        }
        return setNextOptType;
    }
}

