/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgOrderOperationTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyOptLogDomain;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyOptLogReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyOptLogRespDto;
import com.yunxi.dg.base.center.trade.eo.StrategyOptLogEo;
import com.yunxi.dg.base.center.trade.service.IDgStrategyOptLogService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgStrategyOptLogServiceImpl
implements IDgStrategyOptLogService {
    @Resource
    private IDgStrategyOptLogDomain strategyOptLogDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addStrategyOptLog(DgStrategyOptLogReqDto addReqDto) {
        StrategyOptLogEo StrategyOptLogEo2 = new StrategyOptLogEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)StrategyOptLogEo2);
        if (StringUtils.isEmpty((CharSequence)StrategyOptLogEo2.getOptPerson())) {
            StrategyOptLogEo2.setOptPerson("system");
        }
        this.strategyOptLogDomain.insert((BaseEo)StrategyOptLogEo2);
        return StrategyOptLogEo2.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddOrderLogByOptResult(DgOrderOperationTypeEnum orderOperationTypeEnum, Long strategyId, List<String> optResultList) {
        ArrayList addList = Lists.newArrayList();
        for (String optResult : optResultList) {
            StrategyOptLogEo saleOrderOptLogEo = new StrategyOptLogEo();
            saleOrderOptLogEo.setStrategyId(strategyId);
            saleOrderOptLogEo.setOptTime(new Date());
            String optPerson = StringUtils.isNotBlank((CharSequence)ServiceContext.getContext().getRequestUserCode()) ? ServiceContext.getContext().getRequestUserCode() : "system";
            saleOrderOptLogEo.setOptPerson(optPerson);
            saleOrderOptLogEo.setOptType(orderOperationTypeEnum.getDesc());
            saleOrderOptLogEo.setOptContent(optResult);
            addList.add(saleOrderOptLogEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            this.strategyOptLogDomain.insertBatch((List)addList);
        }
    }

    @Override
    public void modifyStrategyOptLog(DgStrategyOptLogReqDto modifyReqDto) {
        StrategyOptLogEo StrategyOptLogEo2 = new StrategyOptLogEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)StrategyOptLogEo2);
        this.strategyOptLogDomain.updateSelective((BaseEo)StrategyOptLogEo2);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStrategyOptLog(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.strategyOptLogDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public DgStrategyOptLogRespDto queryById(Long id) {
        StrategyOptLogEo StrategyOptLogEo2 = (StrategyOptLogEo)this.strategyOptLogDomain.selectByPrimaryKey(id);
        DgStrategyOptLogRespDto DgStrategyOptLogRespDto2 = new DgStrategyOptLogRespDto();
        DtoHelper.eo2Dto((BaseEo)StrategyOptLogEo2, (BaseVo)DgStrategyOptLogRespDto2);
        return DgStrategyOptLogRespDto2;
    }

    @Override
    public PageInfo<DgStrategyOptLogRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        DgStrategyOptLogReqDto StrategyOptLogReqDto2 = (DgStrategyOptLogReqDto)JSON.parseObject((String)filter, DgStrategyOptLogReqDto.class);
        StrategyOptLogEo StrategyOptLogEo2 = new StrategyOptLogEo();
        DtoHelper.dto2Eo((BaseVo)StrategyOptLogReqDto2, (BaseEo)StrategyOptLogEo2);
        StrategyOptLogEo2.setOrderByDesc("id");
        PageInfo eoPageInfo = this.strategyOptLogDomain.selectPage((BaseEo)StrategyOptLogEo2, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DgStrategyOptLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

