/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.tc.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SecondSaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsPcpInventoryExposedRespDto;
import com.yunxi.dg.base.center.inventory.proxy.inventory.ILogicInventoryExposedApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.inventory.IPhysicsInventoryExposedApiProxy;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcInventoryAction;
import com.yunxi.dg.base.center.trade.baseservice.BInventoryApiServcie;
import com.yunxi.dg.base.center.trade.domain.order.event.SaleOrderRemoveLogicalEvent;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderAddrService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.TrackOptLogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DgTcInventoryActionImpl
implements IDgTcInventoryAction {
    private static final Logger log = LoggerFactory.getLogger(DgTcInventoryActionImpl.class);
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private ISaleOrderItemService saleOrderItemService;
    @Resource
    private BInventoryApiServcie bInventoryApiServcie;
    @Resource
    private ISaleOrderAddrService saleOrderAddrService;
    @Resource
    private ILogicInventoryExposedApiProxy logicInventoryExposedApiProxy;
    @Resource
    private IPhysicsInventoryExposedApiProxy physicsInventoryExposedApiProxy;
    @Autowired
    private ApplicationEventPublisher publisher;

    @Override
    public RestResponse<Void> cancelLogicOrder(Long orderId) {
        Boolean cancelResult;
        SaleOrderRespDto saleOrderRespDto = this.saleOrderService.querySaleOrderById(orderId);
        if (Objects.equals(saleOrderRespDto.getOrderStatus(), SaleOrderStatusEnum.WAIT_PICK.getCode()) && Objects.equals(saleOrderRespDto.getSecondOrderStatus(), SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode()) && !(cancelResult = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApiProxy.cancelLogicOrder(saleOrderRespDto.getSaleOrderNo()))).booleanValue()) {
            throw PcpTradeExceptionCode.CHECK_STATUS_ORDER_CANCEL_INVENTORY_CANCEL_FAIL.builderException();
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateInventoryByPreemption(Long orderId) {
        DgSaleOrderEo orderEo = this.saleOrderService.queryEoById(orderId);
        AssertUtils.notNull((Object)orderEo, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        List<DgSaleOrderItemEo> dgSaleOrderItemEos = this.saleOrderItemService.queryEoOrderItemByOrderId(orderId);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(dgSaleOrderItemEos), (String)"\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        try {
            log.info("[\u9500\u552e\u8ba2\u5355]\u9884\u5360\u6e20\u9053\u4ed3\u5e93\u5b58");
            this.bInventoryApiServcie.updateInventoryByPreemption(orderEo, dgSaleOrderItemEos);
            log.info("[\u9500\u552e\u8ba2\u5355]\u9501\u5b9a\u5e93\u5b58\u6210\u529f\uff0c\u5373\u5c06\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff01");
        }
        catch (Exception e) {
            log.info("[\u9500\u552e\u8ba2\u5355]\u9884\u5360\u6e20\u9053\u4ed3\u5e93\u5b58\u5f02\u5e38:{}", (Object)e.getMessage());
            log.error("{},{}", (Object)e.getMessage(), (Object)e);
            TrackOptLogUtils.addOrderTrackOptLog((Long)orderEo.getId(), (String)("\u8ba2\u5355\u9884\u5360\u6e20\u9053\u4ed3\u5e93\u5b58\u5931\u8d25:" + e.getMessage()));
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> preemptInventory(Long orderId) {
        DgSaleOrderEo orderEo = this.saleOrderService.queryEoById(orderId);
        AssertUtils.notNull((Object)orderEo, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        List<DgSaleOrderItemEo> dgSaleOrderItemEos = this.saleOrderItemService.queryEoOrderItemByOrderId(orderId);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(dgSaleOrderItemEos), (String)"\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        try {
            log.info("[\u9500\u552e\u8ba2\u5355]\u9884\u5360\u6e20\u9053\u4ed3\u5e93\u5b58");
            this.bInventoryApiServcie.preemptInventory(orderEo, dgSaleOrderItemEos);
            log.info("[\u9500\u552e\u8ba2\u5355]\u9501\u5b9a\u5e93\u5b58\u6210\u529f\uff0c\u5373\u5c06\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff01");
        }
        catch (Exception e) {
            log.info("[\u9500\u552e\u8ba2\u5355]\u9884\u5360\u6e20\u9053\u4ed3\u5e93\u5b58\u5f02\u5e38:{}", (Object)e.getMessage());
            log.error("{},{}", (Object)e.getMessage(), (Object)e);
            TrackOptLogUtils.addOrderTrackOptLog((Long)orderEo.getId(), (String)("\u8ba2\u5355\u9884\u5360\u6e20\u9053\u4ed3\u5e93\u5b58\u5931\u8d25:" + e.getMessage()));
            throw PcpTradeExceptionCode.SALE_ORDER_PREEMPT_INVENTORY.buildBizException(new Object[]{e.getMessage()});
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> invalidOrderInventory(Long orderId) {
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        AssertUtils.notNull((Object)saleOrderEo, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        List<SaleOrderRespDto> saleOrderRespDtos = this.saleOrderService.queryChildByOriOrderNo(saleOrderEo.getSaleOrderNo());
        log.info("\u9500\u552e\u4e3b\u5355:{}\u5bf9\u5e94\u7684\u5b50\u5355\u4fe1\u606f\uff1a{}", (Object)orderId, JSON.toJSON(saleOrderRespDtos));
        if (CollectionUtils.isEmpty(saleOrderRespDtos)) {
            return RestResponse.VOID;
        }
        Boolean isShoutLogicWarehouse = false;
        try {
            log.info("[\u91ca\u653e\u5e93\u5b58]\u8ba2\u5355\u5df2\u4f5c\u5e9f\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)saleOrderEo.getSaleOrderNo());
            this.bInventoryApiServcie.releaseInventory(saleOrderEo.getSaleOrderNo(), saleOrderEo.getPlatformOrderNo(), saleOrderEo.getOrderType(), isShoutLogicWarehouse, saleOrderEo.getMainOrderNo());
        }
        catch (Exception e) {
            log.error("[\u91ca\u653e\u5e93\u5b58]\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)e);
            TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderEo.getId(), (String)("\u4f5c\u5e9f\u8ba2\u5355\u91ca\u653e\u6e20\u9053\u4ed3\u5e93\u5b58\u5931\u8d25:" + e.getMessage()));
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> continueDelivery(String saleOrderNo) {
        Boolean result = (Boolean)RestResponseHelper.extractData((RestResponse)this.physicsInventoryExposedApiProxy.continueDelivery(saleOrderNo));
        return RestResponse.VOID;
    }

    @Override
    public CsPcpInventoryExposedRespDto preemptOrderInventory(Long orderId, Integer negativeValidate) {
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        List<DgSaleOrderItemEo> orderItemEos = this.saleOrderItemService.queryEoOrderItemByOrderId(orderId);
        DgSaleOrderAddrEo orderAddrEo = this.saleOrderAddrService.queryEoAddressByOrderId(orderId);
        CsPcpInventoryExposedRespDto inventoryExposedRespDto = new CsPcpInventoryExposedRespDto();
        try {
            inventoryExposedRespDto = this.bInventoryApiServcie.preemptOrderInventory(saleOrderEo, orderItemEos, orderAddrEo, negativeValidate);
        }
        catch (Exception e) {
            log.info("\u9884\u5360\u903b\u8f91\u4ed3\u5e93\u5b58\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u5931\u8d25:{}", (Object)e.getMessage());
            log.warn("{},{}", (Object)e.getMessage(), (Object)e);
            log.info("\u53d1\u8d27\u5931\u8d25\u79fb\u9664\u53d1\u8d27\u4ed3:{}", (Object)saleOrderEo.getSaleOrderNo());
            this.publisher.publishEvent((Object)new SaleOrderRemoveLogicalEvent(saleOrderEo.getId(), saleOrderEo.getSaleOrderNo()));
            TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderEo.getId(), (String)"\u914d\u8d27\u5931\u8d25\u79fb\u9664\u6307\u5b9a\u53d1\u8d27\u4ed3:");
            throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{e.getMessage()});
        }
        return inventoryExposedRespDto;
    }

    @Override
    public RestResponse<Boolean> cancelPhysicsOrder(String orderNo) {
        return this.logicInventoryExposedApiProxy.cancelPhysicsOrder(orderNo);
    }

    @Override
    public RestResponse<Boolean> cancelLogicAndPhysicsOrder(String orderNo) {
        return this.logicInventoryExposedApiProxy.cancelLogicAndPhysicsOrder(orderNo);
    }
}

