/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.order.scheduled;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.RequestId;
import com.yunxi.dg.base.center.trade.service.IDgAutoAuditOrderService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"cis.statemachine.oms.cs.auto.scheduled.enable"}, havingValue="true")
@Component
public class DgAutoAuditScheduled {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgAutoAuditScheduled.class);
    @Resource
    private IDgAutoAuditOrderService autoAuditOrderService;

    @Scheduled(cron="${scheduled.auto.audit:0 0/30 * * * ? }")
    public void autoAutoAudit() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u5b9a\u65f6\u5668]\u542f\u52a8\u5ba2\u5ba1\u3001\u5546\u5ba1\u81ea\u52a8\u6267\u884c\u5b9a\u65f6\u8c03\u5ea6\u81ea\u52a8\u5ba1\u6838\u4efb\u52a1!");
        try {
            this.autoAuditOrderService.handleAutoAuditTask();
        }
        catch (Exception e) {
            LOGGER.error("[\u5b9a\u65f6\u5668]\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        LOGGER.info("[\u5b9a\u65f6\u5668]\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
    }

    @Scheduled(cron="${scheduled.scan.customer.strategy.pool:0 0/5 * * * ? }")
    public void scanCustomerStrategyPool() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u5b9a\u65f6\u5668]\u5ba2\u5ba1\u7f13\u51b2\u6c60\u4efb\u52a1");
        LOGGER.info("[\u5b9a\u65f6\u5668]\u5b9a\u65f6\u5668\u542f\u52a8");
        try {
            this.autoAuditOrderService.scanCustomerAutoAuditTask();
        }
        catch (Exception e) {
            LOGGER.error("[\u5b9a\u65f6\u5668]\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        LOGGER.info("[\u5b9a\u65f6\u5668]\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
    }

    @Scheduled(cron="${scheduled.scan.business.strategy.pool:0 0/1 * * * ? }")
    public void scanBusinessStrategyPool() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u5b9a\u65f6\u5668]\u542f\u52a8\u5546\u5ba1\u7f13\u51b2\u6c60\u4efb\u52a1");
        try {
            this.autoAuditOrderService.scanBusinessAutoAuditTask();
        }
        catch (Exception e) {
            LOGGER.error("[\u5b9a\u65f6\u5668]\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        LOGGER.info("[\u5b9a\u65f6\u5668]\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
    }

    @Scheduled(cron="${scheduled.scan.pick.strategy.pool:0 0/5 * * * ? }")
    public void scanPickStrategyPool() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u5b9a\u65f6\u5668]\u542f\u52a8\u81ea\u52a8\u914d\u8d27\u7f13\u51b2\u6c60\u4efb\u52a1");
        try {
            this.autoAuditOrderService.scanPickAutoAuditTask();
        }
        catch (Exception e) {
            LOGGER.error("[\u5b9a\u65f6\u5668]\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        LOGGER.info("[\u5b9a\u65f6\u5668]\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
    }

    @Scheduled(cron="${scheduled.scan.picked.strategy.pool:0 0/5 * * * ? }")
    public void scanPickedStrategyPool() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u5b9a\u65f6\u5668]\u542f\u52a8\u81ea\u52a8\u4e0b\u53d1\u4ed3\u5e93\u7f13\u51b2\u6c60\u4efb\u52a1");
        try {
            this.autoAuditOrderService.scanPickedAutoAuditTask();
        }
        catch (Exception e) {
            LOGGER.error("[\u5b9a\u65f6\u5668]\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        LOGGER.info("[\u5b9a\u65f6\u5668]\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
    }

    @Scheduled(cron="${scheduled.clean.strategy.pool:0 0 0 * * ? }")
    public void cleanStrategyPool() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u5b9a\u65f6\u5668\u6e05\u7406\u7f13\u51b2\u6c60\u4efb\u52a1]\u542f\u52a8\u6e05\u7406\u7f13\u51b2\u6c60\u4efb\u52a1");
        try {
            this.autoAuditOrderService.cleanStrategyPool();
        }
        catch (Exception e) {
            LOGGER.error("[\u5b9a\u65f6\u5668\u6e05\u7406\u7f13\u51b2\u6c60\u4efb\u52a1]\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        LOGGER.info("[\u5b9a\u65f6\u5668\u6e05\u7406\u7f13\u51b2\u6c60\u4efb\u52a1]\u5b9a\u65f6\u5668\u4efb\u52a1\u6267\u884c\u5b8c\u6210!");
    }
}

